package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 出库结果单Eo对象
*
* @author wude
* @since 2022-03-10
*/
@ApiModel(value = "OutResultOrderReqDto", description = "出库结果单Eo对象")
public class OutResultOrderReqDto extends BaseDto {

    /**
    *  单号
    */
    @ApiModelProperty(name = "orderNo", value = "单号")
    private String orderNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     *  发货逻辑仓库名称
     */
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryWarehouseName;
    /**
     *  收货逻辑仓库名称
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货逻辑仓库名称")
    private String receiveWarehouseName;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(
            name = "createBeginTime",
            value = "创建开始时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(
            name = "createEndTime",
            value = "创建结束时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createEndTime;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getDeliveryWarehouseName() {
        return deliveryWarehouseName;
    }

    public void setDeliveryWarehouseName(String deliveryWarehouseName) {
        this.deliveryWarehouseName = deliveryWarehouseName;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public Date getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(Date createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public Date getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(Date createEndTime) {
        this.createEndTime = createEndTime;
    }
}
