package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
* 平台订单表Eo对象
*
* @author haoxiao
* @since 2022-03-10
*/
@Data
@ApiModel(value = "PlatformOrderReqDto", description = "平台订单表Eo对象")
public class PlatformOrderReqDto extends BaseDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  平台订单号
    */
    @ApiModelProperty(name = "orderNo", value = "单号（平台订单号/内部销售订单号）")
    private String orderNo;
    /**
     *  平台下单时间
     */
    @ApiModelProperty(name = "platformCreateTimeStart", value = "平台下单时间开始")
    private Date platformCreateTimeStart;
    /**
     *  平台下单时间
     */
    @ApiModelProperty(name = "platformCreateTimeEnd", value = "平台下单时间结束")
    private Date platformCreateTimeEnd;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeStart", value = "内部订单创建时间开始")
    private Date saleOrderCreateTimeStart;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeEnd", value = "内部订单创建时间结束")
    private Date saleOrderCreateTimeEnd;

    /**
     *  收货人姓名
     */
    @ApiModelProperty(name = "receiveName", value = "收货人姓名")
    private String receiveName;
    /**
     *  收货人手机号
     */
    @ApiModelProperty(name = "receivePhone", value = "收货人手机号")
    private String receivePhone;
    /**
    *  订单类型 0-大B订单 1-积分订单 2-普通订单
    */
    @ApiModelProperty(name = "orderType", value = "订单类型 0-大B订单 1-积分订单 2-普通订单")
    private Integer orderType;
    /**
    *  转单状态 0-正常 1-异常 2-作废
    */
    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 0-正常 1-异常 2-作废")
    private Integer transferOrderStatus;
    /**
    *  店铺id
    */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
    *  店铺渠道
    */
    @ApiModelProperty(name = "shopChannel", value = "店铺渠道")
    private String shopChannel;
    /**
    *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
    */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
    *  订单来源：0：线下 1: 线上
    */
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;
    /**
    *  经销渠道
    */
    @ApiModelProperty(name = "saleChannel", value = "经销渠道")
    private String saleChannel;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付
    */
    @ApiModelProperty(name = "payWay", value = "支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付")
    private String payWay;
    /**
    *  支付状态（0-未支付、1-已支付）
    */
    @ApiModelProperty(name = "payStatus", value = "支付状态（0-未支付、1-已支付）")
    private Integer payStatus;
    /**
     *  平台订单创建人
     */
    @ApiModelProperty(name = "platformOrderCreatePerson", value = "平台订单创建人")
    private String platformOrderCreatePerson;

}
