package com.dtyunxi.tcbj.api.biz.promotion.dto;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import cn.afterturn.easypoi.excel.annotation.Excel;

@Data
public class PromotionExportRow {

    @ApiModelProperty(name = "activityId", value = "活动ID")
    private String activityId;

    @Excel(name = "序号", width = 10)
    @ApiModelProperty(name = "index", value = "序号")
    private Integer index;

    @Excel(name = "事业部", width = 20)
    @ApiModelProperty(name = "division", value = "事业部")
    private String division;

    @Excel(name = "活动编号", width = 30)
    @ApiModelProperty(name = "activityCode", value = "活动编号")
    private String activityCode;

    @Excel(name = "活动名称", width = 40)
    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;

    @Excel(name = "产品类型", width = 15)
    @ApiModelProperty(name = "productType", value = "产品类型")
    private String productType;

    @Excel(name = "产品编码", width = 20)
    @ApiModelProperty(name = "productCode", value = "产品编码")
    private String productCode;

    @Excel(name = "产品名称", width = 40)
    @ApiModelProperty(name = "productName", value = "产品名称")
    private String productName;

    @Excel(name = "建议零售价", width = 15)
    @ApiModelProperty(name = "price", value = "建议零售价")
    private String price;

    @Excel(name = "换购价", width = 15)
    @ApiModelProperty(name = "exchangePrice", value = "换购价")
    private String exchangePrice;

    @Excel(name = "不支持单独购买", width = 15)
    @ApiModelProperty(name = "notAloneBuy", value = "不支持单独购买")
    private String notAloneBuy;

    @Excel(name = "换购方式", width = 15)
    @ApiModelProperty(name = "exchangeMethod", value = "换购方式")
    private String exchangeMethod;

    @Excel(name = "额度类型", width = 15)
    @ApiModelProperty(name = "quotaType", value = "额度类型")
    private String quotaType;

    @Excel(name = "比例", width = 10)
    @ApiModelProperty(name = "ratio", value = "比例")
    private String ratio;

    @Excel(name = "客户类型", width = 20)
    @ApiModelProperty(name = "customerType", value = "客户类型")
    private String customerType;

    @Excel(name = "客户明细", width = 40)
    @ApiModelProperty(name = "customerDetail", value = "客户明细")
    private String customerDetail;

    @Excel(name = "活动开始时间", width = 25)
    @ApiModelProperty(name = "activityStartTime", value = "活动开始时间")
    private String activityStartTime;

    @Excel(name = "活动结束时间", width = 25)
    @ApiModelProperty(name = "activityEndTime", value = "活动结束时间")
    private String activityEndTime;

    @Excel(name = "活动状态", width = 15)
    @ApiModelProperty(name = "activityStatus", value = "活动状态")
    private String activityStatus;

}
