package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel("调拨单明细分页查询EXT响应参数")
public class TransferOrderReportExtRespDto {
    
    @ApiModelProperty("调拨单号")
    private String transferOrderNo;
    
    @ApiModelProperty("渠道单号")
    private String platformOrderNo;
    
    @ApiModelProperty("调出组织")
    private String outOrganization;
    
    @ApiModelProperty("调入组织")
    private String inOrganization;
    
    @ApiModelProperty("调出仓")
    private String outLogicWarehouseName;

    @ApiModelProperty("调出仓Code")
    private String outLogicWarehouseNameCode;
    
    @ApiModelProperty("调入仓")
    private String inLogicWarehouseName;

    @ApiModelProperty("调入仓Code")
    private String inLogicWarehouseNameCode;
    
    @ApiModelProperty("创建时间")
    private Date createTime;
    
    @ApiModelProperty("发货时间")
    private Date deliveryTime;
    
    @ApiModelProperty("调拨单状态")
    private String orderStatus;
    
    @ApiModelProperty("产品编号")
    private String longCode;
    
    @ApiModelProperty("产品名称")
    private String cargoName;
    
    @ApiModelProperty("规格")
    private String specification;
    
    @ApiModelProperty("批次号")
    private String batch;
    
    @ApiModelProperty("生产日期")
    private Date produceTime;
    
    @ApiModelProperty("到期日期")
    private Date expireTime;
    
//    @ApiModelProperty("条码")
//    private String barcode;
    
    @ApiModelProperty("数量")
    private Integer quantity;
} 