package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 放行单Eo对象
*
* @author 无凡
* @since 2023-05-05
*/
@ApiModel(value = "InspectionReleaseOrderReqDto", description = "放行单Eo对象")
@Getter
@Setter
public class InspectionReleaseOrderReportReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  放行单号
    */
    @ApiModelProperty(name = "inspectionReleaseNo", value = "放行单号")
    private String inspectionReleaseNo;
    /**
    *  运单类型：1:预放行 2:正常放行
    */
    @ApiModelProperty(name = "inspectionReleaseType", value = "运单类型：1:预放行 2:正常放行")
    private Integer inspectionReleaseType;
    /**
    *  质检报告委托编号
    */
    @ApiModelProperty(name = "qualityInspectionNo", value = "质检报告委托编号")
    private String qualityInspectionNo;
    /**
    *  质检报告时间
    */
    @ApiModelProperty(name = "qualityInspectionDate", value = "质检报告时间")
    private Date qualityInspectionDate;
    /**
    *  SKU code
    */
    @ApiModelProperty(name = "skuCode", value = "SKU code")
    private String skuCode;
    /**
    *  SKU 名称
    */
    @ApiModelProperty(name = "skuName", value = "SKU 名称")
    private String skuName;
    /**
    *  SKU 规格
    */
    @ApiModelProperty(name = "skuSpec", value = "SKU 规格")
    private String skuSpec;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  计划放行数量
    */
    @ApiModelProperty(name = "planReleaseNum", value = "计划放行数量")
    private BigDecimal planReleaseNum;
    /**
    *  放行数量
    */
    @ApiModelProperty(name = "releaseNum", value = "放行数量")
    private BigDecimal releaseNum;
    /**
    *  放行单状态 0:预放行, 1:已放行, 2:不合格, 3:已撤销
    */
    @ApiModelProperty(name = "orderStatus", value = "放行单状态 0:预放行, 1:已放行, 2:不合格, 3:已撤销")
    private Integer orderStatus;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "reportResult", value = "质检报告结果")
    private String reportResult;

    private List<String> batchList;

    private List<String> skuCodeList;

    private List<Integer> orderStatusList;
}
