/**
 * @(#) OutNoticeOrderVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 出库通知单实体
 */
@Data
@ApiModel(value = "EsOutNoticeOrderVO", description = "出库通知单实体")
public class OutNoticeOrderVO {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private Date createTime;
  
  
  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private Date updateTime;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id;


  @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库逻辑仓库编码")
  private String inLogicWarehouseCode;

  @ApiModelProperty(name = "inLogicWarehouseName", value = "入库逻辑仓库名称")
  private String inLogicWarehouseName;

  @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库逻辑仓库编码")
  private String outLogicWarehouseCode;

  @ApiModelProperty(name = "outLogicWarehouseName", value = "出库逻辑仓库名称")
  private String outLogicWarehouseName;
  
  /**
   * 业务类型
   */
  public enum BusinessTypeEnum {
    _308("308"),
    
    _105("105"),
    
    _309("309"),
    
    _310("310"),
    
    _201("201"),
    
    _106("106");

    private String value;

    BusinessTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BusinessTypeEnum fromValue(String value) {
      for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  
  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="documentNo", value = "当前类型单据号")
  @JsonProperty("documentNo")
  private String documentNo;
  
  
  @ApiModelProperty(name="orderStatus", value = "单据状态")
  @JsonProperty("orderStatus")
  private String orderStatus;
  
  
  @ApiModelProperty(name="relevanceNo", value = "关联业务单号（不同业务类型跳转不同详情）")
  @JsonProperty("relevanceNo")
  private String relevanceNo;
  
  
  @ApiModelProperty(name="externalOrderNo", value = "外部订单号")
  @JsonProperty("externalOrderNo")
  private String externalOrderNo;


  @ApiModelProperty(name="externalOrderType", value = "外部订单类型")
  @JsonProperty("externalOrderType")
  private String externalOrderType;
  
  
  @Valid 
  @ApiModelProperty(name="totalQuantity", value = "发货总数量")
  @JsonProperty("totalQuantity")
  private BigDecimal totalQuantity;
  
  @NotNull 
  @Valid 
  @ApiModelProperty(name="businessOrderInfo", required = true, value = "业务单据信息")
  @JsonProperty("businessOrderInfo")
  private BusinessOrderInfoVO businessOrderInfo = null;
  
  /**
   * 单据类型
   */
  public enum DocumentTypeEnum {
    DELIVERY_NOTICE("DELIVERY_NOTICE"),
    
    DELIVERY_RESULT("DELIVERY_RESULT"),
    
    RECEIVE_NOTICE("RECEIVE_NOTICE"),
    
    RECEIVE_RESULT("RECEIVE_RESULT"),
    
    OUT_NOTICE("OUT_NOTICE"),
    
    OUT_RESULT("OUT_RESULT"),
    
    IN_NOTICE("IN_NOTICE"),
    
    IN_RESULT("IN_RESULT");

    private String value;

    DocumentTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DocumentTypeEnum fromValue(String value) {
      for (DocumentTypeEnum b : DocumentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  @NotNull 
  @ApiModelProperty(name="documentType", required = true, value = "单据类型")
  @JsonProperty("documentType")
  private DocumentTypeEnum documentType;
  
  
  @Valid 
  @ApiModelProperty(name="summary", value = "商品总数量")
  @JsonProperty("summary")
  private BigDecimal summary;
  
  
  @Valid 
  @ApiModelProperty(name="totalSku", value = "SKU总数量")
  @JsonProperty("totalSku")
  private BigDecimal totalSku;
  
  
  @Valid 
  @ApiModelProperty(name="totalBoxesNum", value = "总箱数")
  @JsonProperty("totalBoxesNum")
  private BigDecimal totalBoxesNum;
  
  
  @Valid 
  @ApiModelProperty(name="mixBoxesNum", value = "拼箱数")
  @JsonProperty("mixBoxesNum")
  private BigDecimal mixBoxesNum;
  
  @NotNull 
  @ApiModelProperty(name="bunchCodes", required = true, value = "串码")
  @JsonProperty("bunchCodes")
  private List<String> bunchCodes = new ArrayList<>();
  
  @ApiModelProperty(name="wmsNo", value = "WMS订单号")
  @JsonProperty("wmsNo")
  private String wmsNo = null;


  @ApiModelProperty(name="deliveryWay", value = "发货方式")
  @JsonProperty("deliveryWay")
  private String deliveryWay;


  @ApiModelProperty(name="logisticsCompany", value = "物流公司")
  @JsonProperty("logisticsCompany")
  private String logisticsCompany;


  @ApiModelProperty(name="logisticsNo", value = "物流订单号")
  @JsonProperty("logisticsNo")
  private String logisticsNo;


  @ApiModelProperty(name="outResultNo", value = "出库结果单号")
  @JsonProperty("outResultNo")
  private List<String> outResultNo = null;


  @ApiModelProperty(name="deliveryNoticeNo", value = "发货通知单号")
  @JsonProperty("deliveryNoticeNo")
  private String deliveryNoticeNo;

  @ApiModelProperty(name="bizDate", value = "业务时间")
  @JsonProperty("bizDate")
  private Date bizDate;


  @ApiModelProperty(name="wmsStatus", value = "wms执行状态:receive：接单；receive_complete：收货完成；shelf_review：上架复核；pick_up：拣货；review：复核；shipped：已发货；")
  @JsonProperty("wmsStatus")
  private String wmsStatus;

}

