package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
* 出库/入库通知单wms状态Eo对象
*
* @author 紫霄
* @since 2023-07-24
*/
@ApiModel(value = "CsNoticeWmsStatusRespDto", description = "出库/入库通知单wms状态Eo对象")
@Data
public class CsNoticeWmsStatusRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  wms唯一编码
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "wms唯一编码")
    private String wmsOrderNo;
    /**
    *  通知单号
    */
    @ApiModelProperty(name = "documentNo", value = "通知单号")
    private String documentNo;
    /**
    *  单据类型 out:出库；in:入库
    */
    @ApiModelProperty(name = "type", value = "单据类型 out:出库；in:入库")
    private String type;
    /**
    *  单据状态（wms操作动作） receive：接单；receive_complete：收货完成；shelf_review：上架复核；pick_up：拣货；review：复核；shipped：已发货；
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态（wms操作动作） receive：接单；receive_complete：收货完成；shelf_review：上架复核；pick_up：拣货；review：复核；shipped：已发货；")
    private String orderStatus;
    /**
    *  操作人
    */
    @ApiModelProperty(name = "optPerson", value = "操作人")
    private String optPerson;

    /**
     *  操作时间
     */
    @ApiModelProperty(name = "optTime", value = "操作时间")
    private String optTime;
    /**
    *  操作内容
    */
    @ApiModelProperty(name = "optContent", value = "操作内容")
    private String optContent;

    @ApiModelProperty(name = "relevanceNo", value = "业务单号")
    private String relevanceNo;

    @ApiModelProperty(name = "relevanceNo", value = "业务类型")
    private String businessType;

    private String physicsWarehouseCode;

    private String remark;

    private String physicsWarehouseName;

}
