package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.BudgetItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* 预算项目维护服务接口
*
*/
@Api(tags = {"预算项目维护服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IBudgetItemApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/budgetItem",
    url = "${tcbj.center.report.api:}"
)
public interface IBudgetItemApi {
    /**
     * 新增预算项目
     *
     * @param addReqDto 预算项目请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增预算项目", notes = "新增预算项目")
    RestResponse<Long> addBudgetItem(@RequestBody BudgetItemReqDto addReqDto);

    /**
     * 修改预算项目
     *
     * @param modifyReqDto 预算项目请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改预算项目", notes = "修改预算项目")
    RestResponse<Void> modifyBudgetItem(@RequestBody BudgetItemReqDto modifyReqDto);
}
