package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 库存报表对比Eo对象
*
* @author fengjian
* @since 2022-07-07
*/
@ApiModel(value = "InventoryComparisonReportRespDto", description = "库存报表对比Eo对象")
@Getter
@Setter
public class InventoryComparisonReportRespDto extends BaseRespDto{
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  统计时间
    */
    @ApiModelProperty(name = "statisticsTime", value = "统计时间")
    private Date statisticsTime;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  逻辑仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓编码")
    private String warehouseCode;
    /**
    *  逻辑仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "逻辑仓名称")
    private String warehouseName;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  库存组织
    */
    @ApiModelProperty(name = "organizationName", value = "库存组织")
    private String organizationName;

    @ApiModelProperty(name = "refWarehouseCode", value = "物理仓编码")
    private String refWarehouseCode;

    @ApiModelProperty(name = "refWarehouseName", value = "物理仓")
    private String refWarehouseName;

    @ApiModelProperty(name = "warehouseClassify", value = "逻辑仓分类")
    private String warehouseClassify;

    @ApiModelProperty(name = "warehouseClassifyName", value = "逻辑仓分类")
    private String warehouseClassifyName;

    @ApiModelProperty(name = "warehouseQuality", value = "逻辑仓品质")
    private String warehouseQuality;

    @ApiModelProperty(name = "warehouseQualityName", value = "逻辑仓品质")
    private String warehouseQualityName;
    /**
    *  码拖数量
    */
    @ApiModelProperty(name = "trayNum", value = "码拖数量")
    private Long trayNum;
    /**
    *  pcp库存
    */
    @ApiModelProperty(name = "balance", value = "pcp库存")
    private BigDecimal balance;
    /**
    *  eas库存
    */
    @ApiModelProperty(name = "easNum", value = "eas库存")
    private BigDecimal easNum;
    /**
    *  wms库存
    */
    @ApiModelProperty(name = "wmsNum", value = "wms库存")
    private BigDecimal wmsNum;
    /**
    *  pcp_eas差异
    */
    @ApiModelProperty(name = "pcpEas", value = "pcp_eas差异")
    private BigDecimal pcpEas;
    /**
    *  pcp_wms差异
    */
    @ApiModelProperty(name = "pcpWms", value = "pcp_wms差异")
    private BigDecimal pcpWms;
    /**
    *  eas_wms差异
    */
    @ApiModelProperty(name = "easWms", value = "eas_wms差异")
    private BigDecimal easWms;
    /**
    *  是否存在差异 1:是,0:否;
    */
    @ApiModelProperty(name = "diff", value = "是否存在差异 1:是,0:否;")
    private Integer diff;

}
