package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ShipmentStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.LargeDataScreenRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShipmentStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 近7天已发货统计服务接口
*
* @author 天泽
* @since 2022-12-14
*/
@Api(tags = {"近7天已发货统计服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IShipmentStatisticsQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/shipment/statistics",
    url = "${tcbj.center.report.api:}"
)
public interface IShipmentStatisticsQueryApi {

    /**
    * 根据id查询近7天已发货统计
    *
    * @param id 近7天已发货统计id
    * @return   近7天已发货统计数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询近7天已发货统计", notes = "根据id查询近7天已发货统计")
    RestResponse<ShipmentStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 近7天已发货统计分页数据
    *
    * @param filter   近7天已发货统计查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 近7天已发货统计分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "近7天已发货统计分页数据", notes = "根据filter查询条件查询近7天已发货统计数据，filter=ShipmentStatisticsReqDto")
    RestResponse<PageInfo<ShipmentStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询总数
     * @param queryDto
     * @return
     */
    @PostMapping("/queryTotal")
    @ApiOperation(value = "查询总数", notes = "查询总数")
    RestResponse<ShipmentStatisticsRespDto> queryTotal(@RequestBody ShipmentStatisticsReqDto queryDto);

    /**
     * 查询订单占比
     * @param type 1：近七天，2本月
     * @return
     */
    @PostMapping("/queryOrderProportion")
    @ApiOperation(value = "查询订单占比", notes = "查询订单占比")
    RestResponse<List<LargeDataScreenRespDto>> queryOrderProportion(@RequestParam("type") Integer type);

}
