package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PcpItemReqDto;
import com.dtyunxi.tcbj.api.dto.response.PcpItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 货品服务接口
*
* @author yuangui
* @since 2022-05-26
*/
@Api(tags = {"货品服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IPcpItemApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/pcpItem",
    url = "${tcbj.center.report.api:}"
)
public interface IPcpItemApi {

/**
* 新增货品
*
* @param addReqDto 货品请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增货品", notes = "新增货品")
RestResponse<Long> addPcpItem(@RequestBody PcpItemReqDto addReqDto);

    /**
    * 修改货品
    *
    * @param modifyReqDto 货品请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改货品", notes = "修改货品")
    RestResponse<Void> modifyPcpItem(@RequestBody PcpItemReqDto modifyReqDto);

    /**
    * 删除货品
    *
    * @param ids        货品删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除货品", notes = "删除货品")
    RestResponse<Void> removePcpItem(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
