package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "DailyDeliveryFeeFilterExtConfigReqDto", description = "Eo对象")
public class DailyDeliveryFeeFilterExtConfigReqDto extends RequestDto{

    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  结算模块编码
    */
    @ApiModelProperty(name = "moduleCode", value = "结算模块编码")
    private String moduleCode;
    @ApiModelProperty(name = "moduleCodeList", value = "结算模块编码集合")
    private List<String> moduleCodeList;
    /**
    *  剔除物理仓
    */
    @ApiModelProperty(name = "filterPhysicalWarehouse", value = "剔除物理仓")
    private String filterPhysicalWarehouse;
    /**
    *  剔除逻辑仓
    */
    @ApiModelProperty(name = "filterLogicWarehouse", value = "剔除逻辑仓")
    private String filterLogicWarehouse;
    /**
    *  剔除业务类型
    */
    @ApiModelProperty(name = "filterBusinessType", value = "剔除业务类型")
    private String filterBusinessType;
    /**
    *  剔除库存组织
    */
    @ApiModelProperty(name = "filterInventoryOrg", value = "剔除库存组织")
    private String filterInventoryOrg;
    /**
    *  剔除物流公司及承运方式
    */
    @ApiModelProperty(name = "filterLogistics", value = "剔除物流公司及承运方式")
    private String filterLogistics;

    @ApiModelProperty(name = "logisticsCompany", value = "物流公司")
    private String logisticsCompany;

    @ApiModelProperty(name = "transportStyle", value = "承运方式")
    private String transportStyle;

    @ApiModelProperty(name = "filterPhysicalWarehouseDataList", value = "剔除物理仓Data")
    private List<DailyDeliveryFeeFilterExtConfigDataDto> filterPhysicalWarehouseDataList;

    @ApiModelProperty(name = "filterLogicWarehouseDataList", value = "剔除逻辑仓Data")
    private List<DailyDeliveryFeeFilterExtConfigDataDto> filterLogicWarehouseDataList;

    @ApiModelProperty(name = "filterBusinessTypeDataList", value = "剔除业务类型Data")
    private List<DailyDeliveryFeeFilterExtConfigDataDto> filterBusinessTypeDataList;

    @ApiModelProperty(name = "filterInventoryOrgDataList", value = "剔除库存组织Data")
    private List<DailyDeliveryFeeFilterExtConfigDataDto> filterInventoryOrgDataList;

    @ApiModelProperty(name = "filterLogisticsDataList", value = "剔除物流公司及承运方式Data")
    private List<DailyDeliveryFeeFilterExtConfigLogDataDto> filterLogisticsDataList;

    private int pageNum = 1;
    private int pageSize = 10;


}
