package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(value = "DeliveryTimeLimitRespDto", description = "仓库发货时效统计响应dto")
@Data
public class DeliveryTimeLimitRespDto extends BaseRespDto {
    @ApiModelProperty(name = "statisticalTime", value = "统计时间")
    private String statisticalTime;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓")
    private String outPhysicsWarehouseName;
    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓")
    private String outPhysicsWarehouseCode;
    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "入库物理仓")
    private String inPhysicsWarehouseCode;
    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "入库物理仓")
    private String inPhysicsWarehouseName;

    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "relevanceNo", value = "关联业务单号")
    private String relevanceNo;

    @ApiModelProperty(name = "documentNo", value = "出库通知单单号")
    private String documentNo;

    @ApiModelProperty(name = "documentResultNo", value = "出库结果单单号")
    private String documentResultNo;

    @ApiModelProperty(name = "statisticalTime", value = "推送给仓库时间")
    private String pushTime;

    @ApiModelProperty(name = "statisticalTime", value = "仓库发货返回时间")
    private String warehouseTime;

    @ApiModelProperty(name = "statisticalTime", value = "发货时效(天)")
    private String deliveryTime;

}
