/**
 * @(#) SaleReturnOrderCountVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * SaleReturnOrderCountVO
 */
@Data
@ApiModel(value = "SaleReturnOrderCountVO", description = "")
public class SaleReturnOrderCountVO {

  @ApiModelProperty(
          name = "allCount",
          value = "全部数量"
  )
  private BigDecimal allCount;
  @ApiModelProperty(
          name = "waitCheckCount",
          value = "待确认"
  )
  private BigDecimal waitCheckCount;
  @ApiModelProperty(
          name = "completeCount",
          value = "已完成数量"
  )
  private BigDecimal completeCount;
  @ApiModelProperty(
          name = "waitHandleCount",
          value = "待处理数量"
  )
  private BigDecimal waitHandleCount;
  @ApiModelProperty(
          name = "partOutBoundCount",
          value = "部分入库数量"
  )
  private BigDecimal partOutBoundCount;
  @ApiModelProperty(
          name = "cancelCount",
          value = "已取消数量"
  )
  private BigDecimal cancelCount;
  @ApiModelProperty(
          name = "cancelingCount",
          value = "取消中数量"
  )
  private BigDecimal cancelingCount;

  /**
   * 已确认
   */
  @ApiModelProperty(name = "cancelingCount", value = "已确认数量")
  private BigDecimal hadCheckCount;

  /**
   * 已关闭数量
   */
  @ApiModelProperty(name = "closeCount", value = "已关闭数量")
  private BigDecimal closeCount;

  /**
   * 已作废数量
   */
  @ApiModelProperty(name = "invalidCount", value = "已作废数量")
  private BigDecimal invalidCount;

}

