package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferExtReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferExtRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
@Api(tags = {"在途销售信息服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-ISaleTransferExtApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/saleTransferExt",
        url = "${tcbj.center.report.api:}"
)
public interface ISaleTransferExtApi {

    @PostMapping("queryList")
    @ApiOperation(value = "查询在途销售调拨信息", notes = "查询在途销售调拨信息")
    RestResponse<List<SaleTransferExtRespDto>> queryList(@RequestBody SaleTransferExtReqDto reqDto);
}
