package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DismantleWhiteReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.DismantleWhiteReportRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 全局不拆单白名单服务接口
*
* @author yuangui
* @since 2022-04-26
*/
@Api(tags = {"全局不拆单白名单服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IDismantleWhiteQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/report/dismantleWhite",
    url = "${tcbj.center.report.api:}"
)
public interface IDismantleWhiteReportQueryApi {

    /**
    * 根据id查询全局不拆单白名单
    *
    * @param id 全局不拆单白名单id
    * @return   全局不拆单白名单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询全局不拆单白名单", notes = "根据id查询全局不拆单白名单")
    RestResponse<DismantleWhiteReportRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 全局不拆单白名单分页数据
    *
    * @param filter   全局不拆单白名单查询条件
    * @return 全局不拆单白名单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "全局不拆单白名单分页数据", notes = "根据filter查询条件查询全局不拆单白名单数据，filter=DismantleWhiteReqDto")
    RestResponse<PageInfo<DismantleWhiteReportRespDto>> queryByPage(@RequestBody DismantleWhiteReportReqDto filter);

    /**
     * 全局不拆单白名单数据数量
     *
     * @param filter   全局不拆单白名单查询条件
     * @return 全局不拆单白名单数据数量
     */
    @PostMapping("/queryCount")
    @ApiOperation(value = "全局不拆单白名单数据数量", notes = "根据filter查询条件查询全局不拆单白名单数据，filter=DismantleWhiteReqDto")
    RestResponse<Integer> queryCount(@RequestBody DismantleWhiteReportReqDto filter);

}
