package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

@Api(tags = {"剔除计费扩张配置服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IDailyDeliveryFeeFilterExtConfigApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/dailyDeliveryFeeFilterExtConfig",
        url = "${tcbj.center.report.api:}"
)
public interface IDailyDeliveryFeeFilterExtConfigQueryApi {

    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询", notes = "根据id查询")
    RestResponse<DailyDeliveryFeeFilterExtConfigRespDto> queryById(@PathVariable("id") Long id);

    @PostMapping("/queryByPage")
    @ApiOperation(value = "剔除计费扩张配置分页查询", notes = "剔除计费扩张配置分页查询")
    RestResponse<PageInfo<DailyDeliveryFeeFilterExtConfigRespDto>> queryByPage(@RequestBody DailyDeliveryFeeFilterExtConfigReqDto reqDto);

}
