package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleasePlanReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleasePlanRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 计划放行服务接口
*
* @author 紫霄
* @since 2023-05-10
*/
@Api(tags = {"计划放行服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IInspectionReleasePlanApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/inspectionReleasePlan",
    url = "${tcbj.center.report.api:}"
)
public interface IInspectionReleasePlanApi {

/**
* 新增计划放行
*
* @param addReqDto 计划放行请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增计划放行", notes = "新增计划放行")
RestResponse<Long> addInspectionReleasePlan(@RequestBody InspectionReleasePlanReqDto addReqDto);

    /**
    * 修改计划放行
    *
    * @param modifyReqDto 计划放行请求对象
    * @return 处理结果
    */
    @PostMapping("/modify")
    @ApiOperation(value = "修改计划放行(导入用)", notes = "修改计划放行")
    RestResponse<Void> modifyInspectionReleasePlan(@RequestBody InspectionReleasePlanReqDto modifyReqDto);

    /**
    * 删除计划放行
    *
    * @param ids        计划放行删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除计划放行", notes = "删除计划放行")
    RestResponse<Void> removeInspectionReleasePlan(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
