package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsNoticeWmsStatusReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsNoticeWmsStatusRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 出库/入库通知单wms状态服务接口
*
* @author 紫霄
* @since 2023-07-24
*/
@Api(tags = {"出库/入库通知单wms状态服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ICsNoticeWmsStatusApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/channelLogic",
    url = "${tcbj.center.report.api:}"
)
public interface ICsNoticeWmsStatusApi {

/**
* 新增出库/入库通知单wms状态
*
* @param addReqDto 出库/入库通知单wms状态请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增出库/入库通知单wms状态", notes = "新增出库/入库通知单wms状态")
RestResponse<Long> addCsNoticeWmsStatus(@RequestBody CsNoticeWmsStatusReqDto addReqDto);

    /**
    * 修改出库/入库通知单wms状态
    *
    * @param modifyReqDto 出库/入库通知单wms状态请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改出库/入库通知单wms状态", notes = "修改出库/入库通知单wms状态")
    RestResponse<Void> modifyCsNoticeWmsStatus(@RequestBody CsNoticeWmsStatusReqDto modifyReqDto);

    /**
    * 删除出库/入库通知单wms状态
    *
    * @param ids        出库/入库通知单wms状态删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除出库/入库通知单wms状态", notes = "删除出库/入库通知单wms状态")
    RestResponse<Void> removeCsNoticeWmsStatus(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
