package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "DamageRateReportRespDto", description = "破损率统计结果对象")
public class DamageRateReportRespDto extends BaseRespDto {

    @ApiModelProperty(name = "monthStr", value = "月份")
    private String monthStr;

    @ApiModelProperty(name = "customerId", value = "承运商id")
    private String customerId;

    @ApiModelProperty(name = "customerName", value = "承运商名称")
    private String customerName;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "damageOrderNum", value = "总破损票数（订单量）")
    private Integer damageOrderNum;

    @ApiModelProperty(name = "damageTotalNum", value = "总破损量（产品数）")
    private Integer damageTotalNum;
    @ApiModelProperty(name = "damageTotalAmount", value = "总破损金额")
    private Integer damageTotalAmount;

    @ApiModelProperty(name = "totalOrderNum", value = "总发货票数（订单量）")
    private Integer totalOrderNum;

    @ApiModelProperty(name = "totalNum", value = "总发货数量（产品数）")
    private Integer totalNum;

    @ApiModelProperty(name = "damageOrderNumRate", value = "破损率（订单数）")
    private String damageOrderNumRate;

    @ApiModelProperty(name = "damageGoodsNumRate", value = "破损率（产品数）")
    private String damageGoodsNumRate;

    @ApiModelProperty(name = "cans", value = "罐数")
    private Integer cans;

    @ApiModelProperty(name = "boxes", value = "盒数")
    private Integer boxes;

    @ApiModelProperty(name = "bottles", value = "瓶数")
    private Integer bottles;

    @ApiModelProperty(name = "barrels", value = "桶数")
    private Integer barrels;

    @ApiModelProperty(name = "bags", value = "袋数")
    private Integer bags;

    @ApiModelProperty(name = "quantity", value = "支/台/本/个数")
    private Integer quantity;

    @ApiModelProperty(name = "bigBoxes", value = "箱数")
    private Integer bigBoxes;

    @ApiModelProperty(name = "others", value = "其他")
    private Integer others;

}
