/**
 * @(#) GetPlatformOrderListPageParams.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * GetPlatformOrderListPageParams
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "GetPlatformOrderListPageParams", description = "")
public class GetPlatformOrderListPageParams extends EsBaseReqParams{
//    @NotNull
//    @ApiModelProperty(name="pageSize", required = true, value = "分页大小")
//    @JsonProperty("pageSize")
//    private Integer pageSize;
//
//    @NotNull
//    @ApiModelProperty(name="pageNum", required = true, value = "当前分页")
//    @JsonProperty("pageNum")
//    private Integer pageNum;


    @ApiModelProperty(name="orderNo", value = "单号（平台订单号/内部销售订单号）")
    @JsonProperty("orderNo")
    private String orderNo;


    @ApiModelProperty(name="shopName", value = "店铺名称")
    @JsonProperty("shopName")
    private String shopName;


    @ApiModelProperty(name="platformCreateTimeStart", value = "平台下单时间开始")
    @JsonProperty("platformCreateTimeStart")
    private String platformCreateTimeStart;


    @ApiModelProperty(name="platformCreateTimeEnd", value = "平台下单时间结束")
    @JsonProperty("platformCreateTimeEnd")
    private String platformCreateTimeEnd;


    @ApiModelProperty(name="saleOrderCreateTimeStart", value = "内部订单创建时间开始")
    @JsonProperty("saleOrderCreateTimeStart")
    private String saleOrderCreateTimeStart;


    @ApiModelProperty(name="saleOrderCreateTimeEnd", value = "内部订单创建时间结束")
    @JsonProperty("saleOrderCreateTimeEnd")
    private String saleOrderCreateTimeEnd;


    @ApiModelProperty(name="platformCreateTimeStartDate", value = "平台下单时间开始Date")
    @JsonProperty("platformCreateTimeStartDate")
    private Date platformCreateTimeStartDate;


    @ApiModelProperty(name="platformCreateTimeEndDate", value = "平台下单时间结束Date")
    @JsonProperty("platformCreateTimeEndDate")
    private Date platformCreateTimeEndDate;


    @ApiModelProperty(name="saleOrderCreateTimeStartDate", value = "内部订单创建时间开始Date")
    @JsonProperty("saleOrderCreateTimeStartDate")
    private Date saleOrderCreateTimeStartDate;


    @ApiModelProperty(name="saleOrderCreateTimeEndDate", value = "内部订单创建时间结束Date")
    @JsonProperty("saleOrderCreateTimeEndDate")
    private Date saleOrderCreateTimeEndDate;


    @ApiModelProperty(name="deliveryName", value = "收货人姓名")
    @JsonProperty("deliveryName")
    private String deliveryName;


    @ApiModelProperty(name="deliveryPhone", value = "收货人电话")
    @JsonProperty("deliveryPhone")
    private String deliveryPhone;


    @ApiModelProperty(name = "orderType", value = "订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'")
    @JsonProperty("orderType")
    private String orderType;


    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 -1-待转单 0-正常 1-异常 2-作废 3-已合并")
    @JsonProperty("transferOrderStatus")
    private String transferOrderStatus;


    @ApiModelProperty(name="customerName", value = "客户名称")
    @JsonProperty("customerName")
    private String customerName;

    @ApiModelProperty(name="customerCode", value = "客户编码")
    @JsonProperty("customerCode")
    private String customerCode;

    @ApiModelProperty(name="platformOrderCreatePerson", value = "平台订单创建人")
    @JsonProperty("platformOrderCreatePerson")
    private String platformOrderCreatePerson;


    @ApiModelProperty(name="saleChannel", value = "经销渠道")
    @JsonProperty("saleChannel")
    private String saleChannel;

    @ApiModelProperty(name ="channelWarehouseName",value = "渠道仓名称")
    @JsonProperty("channelWarehouseName")
    private String channelWarehouseName;

    @ApiModelProperty(name ="channelWarehouseCode",value = "渠道仓编码")
    @JsonProperty("channelWarehouseCode")
    private String channelWarehouseCode;

    @ApiModelProperty( name = "orderChannelName",value = "订单渠道名称")
    @JsonProperty("orderChannelName")
    private String orderChannelName;

    @ApiModelProperty(name ="defaultLogicalWarehouseName",value = "默认逻辑仓")
    @JsonProperty("defaultLogicalWarehouseName")
    private String defaultLogicalWarehouseName;

    /**
     * 第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)
     */
    @JsonProperty("sourceOrderNo")
    @ApiModelProperty(name = "sourceOrderNo",value = "第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)")
    private String sourceOrderNo;


    /**
     * 转单号
     */
    @JsonProperty("transformOrderNo")
    @ApiModelProperty(name = "transformOrderNo",value = "转单号")
    private String transformOrderNo;

    /**
     * 关联转单号
     */
    @JsonProperty("reTransformOrderNo")
    @ApiModelProperty(name = "reTransformOrderNo",value = "关联转单号")
    private String reTransformOrderNo;

    @ApiModelProperty(name="platformParentOrderNo", value = "渠道订单父单号")
    @JsonProperty("platformParentOrderNo")
    private String platformParentOrderNo;

    private List<String> orderNoList;

    @ApiModelProperty( name = "goodsSku",value = "商品长编码")
    private String goodsSku;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;


    private List<String> excludeOrderTypeList;

    @ApiModelProperty(name = "orderType", value = "订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'")
    @JsonProperty("orderTypeList")
    private List<String> orderTypeList;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "regionName", value = "区域名称")
    private String regionName;

    @ApiModelProperty(name = "type", value = "类型，区别物流索赔单和渠道订单。")
    private String type;

    @ApiModelProperty(name="lossInsuranceCompany", value = "托运单号")
    @JsonProperty("lossInsuranceCompany")
    private String lossInsuranceCompany;


}

