package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.api.dto.request.UpdatePullStatusReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 仓储费用分摊表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储费用分摊表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IStorageChargeApportionApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeApportion",
    url = "${tcbj.center.report.api:}"
)
public interface IStorageChargeApportionApi {

    /**
     * 仓储货权分摊
     * @param storageChargeApportionReqDto
     * @return
     */
    @PostMapping("/storageChargeApportion")
    @ApiOperation(value = "仓储货权分摊", notes = "仓储货权分摊")
    RestResponse<Void> storageChargeApportion(@RequestBody StorageChargeApportionReqDto storageChargeApportionReqDto);

    /**
     * 更新可拉单状态（SAP凭证号回写成功后调用）
     * @param updatePullStatusReqDto
     * @return
     */
    @PostMapping("/updatePullStatus")
    @ApiOperation(value = "更新可拉单状态", notes = "SAP凭证号回写成功后，将相关单据标记为已拉单状态")
    RestResponse<Void> updatePullStatus(@RequestBody UpdatePullStatusReqDto updatePullStatusReqDto);

}
