package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "SortingBillCountDto", description = "分拣账单报表统计对象")
public class SortingBillCountDto {
    /**
     *  大箱数量
     */
    @ApiModelProperty(name = "bigBoxNum", value = "大箱数量")
    private BigDecimal bigBoxNum;
    /**
     *  小箱数量
     */
    @ApiModelProperty(name = "smallBoxNum", value = "小箱数量")
    private BigDecimal smallBoxNum;
    /**
     *  个数
     */
    @ApiModelProperty(name = "boxNum", value = "个数")
    private BigDecimal boxNum;
    /**
     *  调整金额
     */
    @ApiModelProperty(name = "adjustNum", value = "调整金额")
    private BigDecimal adjustNum;
    /**
     *  分拣费
     */
    @ApiModelProperty(name = "sortingNum", value = "合计分拣费")
    private BigDecimal sortingNum;
}
