package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SgSourceLogReqDto;
import com.dtyunxi.tcbj.api.dto.response.SgSourceLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 寻源日志服务接口
*
* @author yuangui
* @since 2022-04-19
*/
@Api(tags = {"寻源日志服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ISgSourceLogQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/sgSourceLog",
    url = "${tcbj.center.report.api:}"
)
public interface ISgSourceLogQueryApi {

    /**
    * 根据id查询寻源日志
    *
    * @param id 寻源日志id
    * @return   寻源日志数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询寻源日志", notes = "根据id查询寻源日志")
    RestResponse<SgSourceLogRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 寻源日志分页数据
    *
    * @param filter   寻源日志查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 寻源日志分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "寻源日志分页数据", notes = "根据filter查询条件查询寻源日志数据，filter=SgSourceLogReqDto")
    RestResponse<PageInfo<SgSourceLogRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
