package com.dtyunxi.tcbj.api.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class SaleReturnDetailReqDto {

    @ApiModelProperty(name = "createTimeStart", value = "入库时间开始")
    @JsonProperty("createTimeStart")
    private Date createTimeStart;

    @ApiModelProperty(name = "createTimeEnd", value = "入库时间结束")
    @JsonProperty("createTimeEnd")
    private Date createTimeEnd;

    @ApiModelProperty(name = "organizationIds", value = "销售组织ID集合")
    @JsonProperty("organizationIds")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "refundStatusList", value = "退货状态集合")
    @JsonProperty("refundStatusList")
    private List<String> refundStatusList;

    @ApiModelProperty(name="pageNum", value = "页码")
    @JsonProperty("pageNum")
    private Integer pageNum = 1;

    @ApiModelProperty(name="pageSize", value = "每页数量")
    @JsonProperty("pageSize")
    private Integer pageSize = 10;

    @ApiModelProperty(name = "sapOrderNo", value = "SAP销售单号")
    @JsonProperty("sapOrderNo")
    private String sapOrderNo;

    @ApiModelProperty(name = "platformRefundNo", value = "营销云单号")
    @JsonProperty("platformRefundNo")
    private String platformRefundNo;

    @ApiModelProperty(name = "saleRefundNo", value = "OCS退货单号")
    @JsonProperty("saleRefundNo")
    private String saleRefundNo;

    @ApiModelProperty(name = "organizationCode", value = "销售组织")
    @JsonProperty("organizationCode")
    private String organizationCode;

    @ApiModelProperty(name = "receiveLogicWarehouseCode", value = "发货库存地点编码")
    @JsonProperty("receiveLogicWarehouseCode")
    private String receiveLogicWarehouseCode;

    @ApiModelProperty(name = "receiveLogicWarehouseName", value = "发货库存地点名称")
    @JsonProperty("receiveLogicWarehouseName")
    private String receiveLogicWarehouseName;

    @ApiModelProperty(name = "customerCode", value = "退货客户编码")
    @JsonProperty("customerCode")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "退货客户名称")
    @JsonProperty("customerName")
    private String customerName;

    @ApiModelProperty(name = "skuCode", value = "物料编号")
    @JsonProperty("skuCode")
    private String skuCode;

    @ApiModelProperty(name = "skuName", value = "物料名称")
    @JsonProperty("skuName")
    private String skuName;
}


