package com.dtyunxi.tcbj.api.dto.request;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 药店查询请求参数Dto 对象
 * @author haoyang
 * @date : 2022/01/08 16:07
 * @since 1.0.0
 */
@Data
@ApiModel(value = "StoreSearchReqDto", description = "药店查询请求参数Dto对象")
public class StoreSearchReqDto extends PageInfo<StoreSearchReqDto> {

    @ApiModelProperty(name = "storeName", value = "药店名称（机构名称）")
    private String storeName;

    @ApiModelProperty(name = "socialCreditNum", value = "信用代码")
    private String socialCreditNum;

    @ApiModelProperty(name = "storeType", value = "药店分类")
    private String storeType;

    @ApiModelProperty(name = "ifCustomer", value = "是否客户 1：是 0：否")
    private Integer ifCustomer;

    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;

    //客户公司社会信用代码（客户编号转换）
    private List<String> customerCompanyCreditCodes;

    @ApiModelProperty(name = "parentOrgName", value = "上级公司")
    private String parentOrgName;

    @ApiModelProperty(name = "parentCreditCode", value = "上级公司信用代码")
    private String parentCreditCode;

    @ApiModelProperty(name = "ifParentCustomer", value = "上级是否客户 1：是 0：否")
    private Integer ifParentCustomer;

    @ApiModelProperty(name = "parentCustomerCode", value = "上级客户编号")
    private String parentCustomerCode;

    //上级客户公司社会信用代码（上级客户编号转换）
    private List<String> parentCustomerCompanyCreditCodes;

    @ApiModelProperty(name = "parentDistributionName", value = "上级分销商")
    private String parentDistributionName;

    @ApiModelProperty(name = "distributionCreditCode", value = "分销商信用代码")
    private String distributionCreditCode;

    @ApiModelProperty(name = "distributionCustomerCode", value = "分销商客户编号")
    private String distributionCustomerCode;

    @ApiModelProperty(name = "customerCode", value = "省市区")
    private List<String> areaList;

    @ApiModelProperty(name = "ifSupply", value = "是否供货  1：是 0：否")
    private Integer ifSupply;

    @ApiModelProperty(name = "storeIds", value = "药店机构ids")
    private List<String> storeIds;

    @ApiModelProperty(name = "orgId", value = "当前大B组织id")
    private Long orgId;

    @ApiModelProperty(name = "creditCodeList", value = "当前大B客户得统一社会信用代码")
    private List<String> creditCodeList;

    @ApiModelProperty(name = "socialCreditNums", value = "药店信用代码和上级信用代码")
    private List<String> socialCreditNums;

    @ApiModelProperty(name = "customerCreditCodes", value = "客户的信用代码")
    private List<String> customerCreditCodes;

    @ApiModelProperty(name = "parentCustomerCreditCodes", value = "上级客户的信用代码")
    private List<String> parentCustomerCreditCodes;

    @ApiModelProperty(name = "brandCode", value = "品牌编码")
    private String brandCode;

    @ApiModelProperty(name = "storeCategoryCode", value = "药店类别CODE")
    private String storeCategoryCode;
}
