package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author minyue
 * @description: 品牌方运营分析报表
 * @since 2022-01-20 18:00
 */
@Api(tags = {"报表中心：品牌方运营分析报表"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/brandReport",
        url = "${tcbj.center.report.api:}"
)
public interface IBrandReportQueryApi {

    @PostMapping("/freeGiftSummaryStatistics")
    @ApiOperation("免费赠品汇总")
    RestResponse<PageInfo<FreeGiftSummaryRespDto>> freeGiftSummaryStatistics(@RequestBody FreeGiftSummaryReqDto freeGiftSummaryReqDto);

    @PostMapping("/discountStatistics")
    @ApiOperation("折扣汇总")
    RestResponse<PageInfo<RebateDetailRespDto>> discountStatistics(@RequestBody RebateDetailReqDto rebateDetailReqDto);

    @PostMapping("/creditStatementStatistics")
    @ApiOperation("授信账单汇总")
    RestResponse<PageInfo<CreditStatementStatisticsRespDto>> creditStatementStatistics(@RequestBody CreditStatementStatisticsReqDto creditStatementStatisticsReqDto);

    @PostMapping("/accountBillStatistics")
    @ApiOperation("账期汇总")
    RestResponse<PageInfo<AccountBillStatisticsRespDto>> accountBillStatistics(@RequestBody AccountBillStatisticsReqDto accountBillStatisticsReqDto);

    @PostMapping("/activityStatistics")
    @ApiOperation("促销活动汇总")
    RestResponse<PageInfo<PromotionalActivitiesStatisticsRespDto>> activityStatistics(@RequestBody PromotionalActivitiesStatisticsReqDto promotionalActivitiesStatisticsReqDto);

}
