/**
 * @(#) PlatformOrderVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;

/**
 * PlatformOrderVO
 */
@Data
@ApiModel(value = "PlatformOrderVO", description = "")
public class PlatformOrderVO {

    @ApiModelProperty(name="createTime", value = "创建时间")
    @JsonProperty("createTime")
    private String createTime;


    @ApiModelProperty(name="updateTime", value = "更新时间")
    @JsonProperty("updateTime")
    private String updateTime;


    @ApiModelProperty(name = "createPerson", value = "创建人")
    @JsonProperty("createPerson")
    private String createPerson;


    @ApiModelProperty(name = "updatePerson", value = "更新人")
    @JsonProperty("updatePerson")
    private String updatePerson;


    @ApiModelProperty(name = "id", value = "唯一id")
    @JsonProperty("id")
    private Long id;


    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    @JsonProperty("platformOrderNo")
    private String platformOrderNo;


    @ApiModelProperty(name = "payTime", value = "支付时间")
    @JsonProperty("payTime")
    private Date payTime;


    @ApiModelProperty(name = "shopName", value = "店铺名称")
    @JsonProperty("shopName")
    private String shopName;


    @ApiModelProperty(name = "shopChannel", value = "店铺渠道")
    @JsonProperty("shopChannel")
    private String shopChannel;


    @ApiModelProperty(name = "customerName", value = "客户名称")
    @JsonProperty("customerName")
    private String customerName;


    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    @JsonProperty("sellerRemark")
    private String sellerRemark;


    @Valid
    @ApiModelProperty(name = "orderAddress", value = "")
    @JsonProperty("orderAddress")
    private AddressVO orderAddress;


    @ApiModelProperty(name = "deliveryName", value = "收件人姓名")
    @JsonProperty("deliveryName")
    private String deliveryName;


    @ApiModelProperty(name = "deliveryPhone", value = "收件人电话")
    @JsonProperty("deliveryPhone")
    private String deliveryPhone;


    @ApiModelProperty(name = "saleOrderNo", value = "内部销售订单")
    @JsonProperty("saleOrderNo")
    private String saleOrderNo;


    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 -1-待转单 0-正常 1-异常 2-作废 3-已合并")
    @JsonProperty("transferOrderStatus")
    private String transferOrderStatus;


    @ApiModelProperty(name = "platformCreateTime", value = "平台创建时间/平台下单时间")
    @JsonProperty("platformCreateTime")
    private Date platformCreateTime;


    @ApiModelProperty(name = "transferOrderTime", value = "转单时间")
    @JsonProperty("transferOrderTime")
    private Date transferOrderTime;


    @ApiModelProperty(name = "succDesc", value = "转单成功描述")
    @JsonProperty("succDesc")
    private String succDesc;


    @ApiModelProperty(name = "exceptionReason", value = "转单异常原因")
    @JsonProperty("exceptionReason")
    private String exceptionReason;


    @ApiModelProperty(name = "obsoletePerson", value = "作废人")
    @JsonProperty("obsoletePerson")
    private String obsoletePerson;


    @ApiModelProperty(name = "obsoleteTime", value = "作废时间")
    @JsonProperty("obsoleteTime")
    private Date obsoleteTime;


    @ApiModelProperty(name = "obsoleteReason", value = "作废原因")
    @JsonProperty("obsoleteReason")
    private String obsoleteReason;


    @Valid
    @ApiModelProperty(name = "orderTotalAmount", value = "订单应收金额")
    @JsonProperty("orderTotalAmount")
    private BigDecimal orderTotalAmount;


    @Valid
    @ApiModelProperty(name = "payAmount", value = "支付金额")
    @JsonProperty("payAmount")
    private BigDecimal payAmount;


    @Valid
    @ApiModelProperty(name = "goodsTotalAmount", value = "商品总金额")
    @JsonProperty("goodsTotalAmount")
    private BigDecimal goodsTotalAmount;


    @ApiModelProperty(name = "payWay", value = "支付方式")
    @JsonProperty("payWay")
    private String payWay;


    @ApiModelProperty(name = "payStatus", value = "支付状态")
    @JsonProperty("payStatus")
    private String payStatus;


    @Valid
    @ApiModelProperty(name = "payableAmount", value = "客户应付金额")
    @JsonProperty("payableAmount")
    private BigDecimal payableAmount;


    @ApiModelProperty(name = "orderType", value = "订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'")
    @JsonProperty("orderType")
    private String orderType;


    @ApiModelProperty(name = "saleOrderCreateTime", value = "内部销售订单创建时间")
    @JsonProperty("saleOrderCreateTime")
    private Date saleOrderCreateTime;


    @Valid
    @JsonProperty("isOnline")
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;

    @Valid
    @ApiModelProperty(name = "onlineFlag", value = "是否线上（0否、1是）")
    @JsonProperty("onlineFlag")
    private BigDecimal onlineFlag;

    /**
     *  是否允许拆单标识：0-否 1-是
     */
    @ApiModelProperty(name = "canSplitFlag", value = "是否允许拆单标识：0-否 1-是")
    private Integer canSplitFlag;


    @ApiModelProperty(name = "saleChannel", value = "经销渠道")
    @JsonProperty("saleChannel")
    private String saleChannel;

    @ApiModelProperty(name = "orderChannelCode", value = "订单渠道编码")
    private String orderChannelCode;

    @ApiModelProperty(name = "orderChannelName", value = "订单渠道名称")
    private String orderChannelName;

    @ApiModelProperty(name = "customerCode", value = "客户编码")
    @JsonProperty("customerCode")
    private String customerCode;


    @Valid
    @ApiModelProperty(name = "goodsTotalNum", value = "明细数量汇总（商品总数量）")
    @JsonProperty("goodsTotalNum")
    private BigDecimal goodsTotalNum;


    @Valid
    @ApiModelProperty(name = "skuTotalNum", value = "sku数量")
    @JsonProperty("skuTotalNum")
    private BigDecimal skuTotalNum;


    @ApiModelProperty(name = "platformOrderCreatePerson", value = "平台订单创建人")
    @JsonProperty("platformOrderCreatePerson")
    private String platformOrderCreatePerson;

    @ApiModelProperty(name ="channelWarehouseName",value = "渠道仓名称")
    @JsonProperty("channelWarehouseName")
    private String channelWarehouseName;

    @ApiModelProperty(name ="channelWarehouseCode",value = "渠道仓编码")
    @JsonProperty("channelWarehouseCode")
    private String channelWarehouseCode;

    @ApiModelProperty(name ="defaultLogicalWarehouseName",value = "默认逻辑仓")
    @JsonProperty("defaultLogicalWarehouseName")
    private String defaultLogicalWarehouseName;
    /**
     *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
     */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    @JsonProperty("orderSource")
    private Integer orderSource;

    /**
     *  销售订单创建时间
     */
    @JsonProperty("saleCreateTime")
    @ApiModelProperty(name = "saleCreateTime", value = "销售订单创建时间")
    private Date saleCreateTime;

    /**
     *  组织id
     */
    @JsonProperty("组织id")
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
     *  组织code
     */
    @JsonProperty("organizationCode")
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
     *  组织名称
     */
    @JsonProperty("organizationName")
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     *  平台父订单号
     */
    @JsonProperty("platformParentOrderNo")
    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;


    /**
     *  店铺id
     */
    @JsonProperty("shopId")
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
     *  店铺编号
     */
    @JsonProperty("shopCode")
    @ApiModelProperty(name = "shopCode", value = "店铺编号")
    private String shopCode;

    /**
     *  店铺渠道ID
     */
    @JsonProperty("shopChannelId")
    @ApiModelProperty(name = "shopChannelId", value = "店铺渠道ID")
    private Long shopChannelId;
    /**
     *  店铺渠道code
     */
    @JsonProperty("shopChannelCode")
    @ApiModelProperty(name = "shopChannelCode", value = "店铺渠道code")
    private String shopChannelCode;

    /**
     *  订单渠道id
     */
    @JsonProperty("orderChannelId")
    @ApiModelProperty(name = "orderChannelId", value = "订单渠道id")
    private Long orderChannelId;


    /**
     *  客户id
     */
    @JsonProperty("customerId")
    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;

    /**
     *  商品sku总数量
     */
    @JsonProperty("goodsSkuTotalNum")
    @ApiModelProperty(name = "goodsSkuTotalNum", value = "商品sku总数量")
    private BigDecimal goodsSkuTotalNum;

    /**
     *  渠道仓库id
     */
    @JsonProperty("channelWarehouseId")
    @ApiModelProperty(name = "channelWarehouseId", value = "渠道仓库id")
    private Long channelWarehouseId;
    /**
     *  默认发货仓id
     */
    @JsonProperty("defaultWarehouseId")
    @ApiModelProperty(name = "defaultWarehouseId", value = "默认发货仓id")
    private Long defaultWarehouseId;
    /**
     *  默认发货仓编码
     */
    @JsonProperty("defaultWarehouseCode")
    @ApiModelProperty(name = "defaultWarehouseCode", value = "默认发货仓编码")
    private String defaultWarehouseCode;
    /**
     *  默认发货仓编码名称
     */
    @JsonProperty("defaultWarehouseName")
    @ApiModelProperty(name = "defaultWarehouseName", value = "默认发货仓编码名称")
    private String defaultWarehouseName;
    /**
     *  订单备注
     */
    @JsonProperty("remark")
    @ApiModelProperty(name = "remark", value = "订单备注 ")
    private String remark;

    /**
     *  第三方客户租户id
     */
    @JsonProperty("thirdPartyId")
    @ApiModelProperty(name = "thirdPartyId", value = "第三方客户租户id")
    private String thirdPartyId;

    @JsonProperty("ifEas")
    @ApiModelProperty(name = "ifEas", value = "是否财务后置单 0是1 否；默认0")
    private Integer ifEas;

    @JsonProperty("orderBizType")
    @ApiModelProperty(name = "orderBizType", value = "订单业务类型 0:普通订单,1:非药业-财务前置")
    private Integer orderBizType;

    @JsonProperty("easOrgId")
    @ApiModelProperty(name = "easOrgId", value = "EAS必须-组织编码")
    private String easOrgId;

    @JsonProperty("deliveryDate")
    @ApiModelProperty(name = "deliveryDate", value = "交货日期")
    private String deliveryDate;

    @JsonProperty("sendDate")
    @ApiModelProperty(name = "sendDate", value = "发货日期")
    private String sendDate;

    @JsonProperty("oldOrderId")
    @ApiModelProperty(name = "oldOrderId", value = "合单前的旧订单id")
    private String oldOrderId;

    /**
     * 第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)
     */
    @JsonProperty("sourceOrderNo")
    @ApiModelProperty(name = "sourceOrderNo",value = "第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)")
    private String sourceOrderNo;


    /**
     * 转单号
     */
    @JsonProperty("transformOrderNo")
    @ApiModelProperty(name = "transformOrderNo",value = "转单号")
    private String transformOrderNo;

    /**
     * 关联转单号
     */
    @JsonProperty("reTransformOrderNo")
    @ApiModelProperty(name = "reTransformOrderNo",value = "关联转单号")
    private String reTransformOrderNo;

    /**
     * 是否预占库存 0否，1是,默认1
     */
    @JsonProperty("releaseState")
    @ApiModelProperty(name = "releaseState",value = "是否预占库存 0否，1是,默认1")
    private Integer releaseState;

    /**
     * 客户表easCode
     */
    @JsonProperty("easCode")
    @ApiModelProperty(name = "easCode",value = "客户表easCode")
    private String easCode;

    /**
     * csp传下来的rdc物理仓(与rdc字段无关)
     */
    @ApiModelProperty(name = "storagePlace",value = "csp传下来的rdc物理仓(与rdc字段无关)")
    private String storagePlace;

    /**
     * 指定供货仓id
     */
    @ApiModelProperty(name = "storagePlaceId",value = "指定供货仓id")
    private Long storagePlaceId;

    /**
     * 指定供货仓
     */
    @ApiModelProperty(name = "storagePlaceName",value = "指定供货仓名称")
    private String storagePlaceName;

    private String province;

    private String city;

    private String district;

    private String detailAddress;

    /**
     * 区域编号
     */
    @ApiModelProperty(name = "regionCode", value = "区域编号")
    private String regionCode;
    /**
     * 区域名称
     */
    @ApiModelProperty(name = "regionName", value = "区域名称")
    private String regionName;

    @ApiModelProperty(name = "claimLogisticsNo", value = "物流索赔单号")
    private String claimLogisticsNo;

    @ApiModelProperty(name="easOrderNo", value = "eas单号")
    @JsonProperty("easOrderNo")
    private String easOrderNo;

    @ApiModelProperty(name = "lossInsuranceCompany", value = "托运单号")
    private String lossInsuranceCompany;

    @ApiModelProperty(name = "allotType", value = "麦优调拨类型：maiyou_cc_allot:cc跨组织调拨;maiyou_bc_allot:bc跨组织调拨")
    private String allotType;
    @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓")
    private String allotOutWarehouseCode;
    @ApiModelProperty(name = "allotOutWarehouseName", value = "调出仓名称")
    private String allotOutWarehouseName;
    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓")
    private String allotInWarehouseCode;
    @ApiModelProperty(name = "allotInWarehouseName", value = "调入仓名称")
    private String allotInWarehouseName;

    @ApiModelProperty(name = "distributor", value = "配送商")
    private String distributor;

    @ApiModelProperty(name = "distributorUcc", value = "配送商信用代码")
    private String distributorUcc;
}

