package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportPollNumDto;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 快递费用报表详情服务接口
 *
 * @author 天泽
 * @since 2022-11-17
 */
@Api(tags = {"快递费用报表详情服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IExpressCostDetailApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/express/cost/detail",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressCostDetailApi {

    /**
     * 新增快递费用报表详情
     *
     * @param addReqDto 快递费用报表详情请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增快递费用报表详情", notes = "新增快递费用报表详情")
    RestResponse<Long> addExpressCostDetail(@RequestBody ExpressCostDetailReqDto addReqDto);

    /**
     * 修改快递费用报表详情
     *
     * @param modifyReqDto 快递费用报表详情请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改快递费用报表详情", notes = "修改快递费用报表详情")
    RestResponse<Void> modifyExpressCostDetail(@RequestBody ExpressCostDetailReqDto modifyReqDto);

    /**
     * 删除快递费用报表详情
     *
     * @param id 快递费用报表详情删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除快递费用报表详情", notes = "删除快递费用报表详情")
    RestResponse<Void> removeExpressCostDetail(@PathVariable("id") Long id);

    /**
     * 修改快递费用报表详情
     *
     * @param modifyReqDto 快递费用报表详情请求对象
     * @return 处理结果
     */
    @PutMapping("/edit")
    @ApiOperation(value = "修改快递费用报表详情", notes = "修改快递费用报表详情")
    RestResponse<Void> edit(@RequestBody ExpressCostDetailReqDto modifyReqDto);


    /**
     * 拆分快递运费报表
     *
     * @param reportId 拆分快递运费报表
     * @return 处理结果
     */
    @DeleteMapping("/split/{reportId}")
    @ApiOperation(value = "拆分快递运费报表", notes = "拆分快递运费报表")
    RestResponse<Void> splitExpressCostDetail(@PathVariable("reportId") Long reportId);

    /**
     * 快递费-更新账单数据
     *
     * @param reqDto 更新账单数据
     * @return 处理结果
     */
    @PostMapping("/againCalculate")
    @ApiOperation(value = "更新账单数据", notes = "更新账单数据")
    RestResponse<Void> againCalculate(@RequestBody AgainCalculateReqDto reqDto);


    @PostMapping("/againCalculateDocumentNo")
    @ApiOperation(value = "更新账单数据,根据结果单号去更新", notes = "更新账单数据，根据结果单号去更新")
    RestResponse<Void> againCalculateDocumentNo(@RequestBody AgainCalculateReqDto reqDto);

    /**
     * 快递费-修改票数
     *
     * @param queryDto 更新账单数据
     * @return 处理结果
     */
    @PostMapping("/modifyPoll")
    @ApiOperation(value = "快递费-修改票数", notes = "快递费-修改票数")
    RestResponse<Void> modifyPoll(@RequestBody ExpressCostReportPollNumDto queryDto);

    /**
     * 快递费-更新
     *
     * @param updateList 更新
     * @return 处理结果
     */
    @PostMapping("/batchUpdate")
    @ApiOperation(value = "快递费-更新", notes = "快递费-更新")
    RestResponse<Void> batchUpdate(@RequestBody List<ExpressCostDetailReqDto> updateList);

    /**
     * 快递费-单据批量插入
     *
     * @param updateList 更新
     * @return 处理结果
     */
    @PostMapping("/batchInsert")
    @ApiOperation(value = "快递费-单据批量插入", notes = "快递费-单据批量插入")
    RestResponse<Void> batchInsert(@RequestBody List<ExpressCostDetailReqDto> updateList);

    @PostMapping("/syncData")
    @ApiOperation(value = "快递费-同步数据", notes = "快递费-同步数据")
    RestResponse<Void> syncData(@RequestBody LogisticStatisticReqDto reqDto);

    @PostMapping("/importBatchUpdate")
    @ApiOperation(value = "快递费-导入批量更新", notes = "快递费-导入批量更新")
    RestResponse<Void> importBatchUpdate(@RequestBody List<ExpressCostDetailReqDto> updateList);

    @PostMapping("/updateExpressBackRemake")
    @ApiOperation(value = "快递费-更新快递回传重量", notes = "快递费-更新快递回传重量")
    RestResponse<Void> updateExpressBackRemake(@RequestBody List<ExpressCostDetailReqDto> reqDtoList);

    @PostMapping("/updateChargedWeight")
    @ApiOperation(value = "快递费-更新计费重量", notes = "快递费-更新计费重量")
    RestResponse<Void> updateChargedWeight(@RequestBody List<ExpressCostDetailReqDto> reqDtoList);

    @PostMapping("/ignoreRepeat")
    @ApiOperation(value = "快递费-忽略重复", notes = "快递费-忽略重复")
    RestResponse<Void> ignoreRepeat(@RequestBody List<ExpressCostDetailReqDto> reqDtoList);

    @PostMapping("/batchRemoveExpressCostDetail")
    @ApiOperation(value = "快递费-批量删除", notes = "快递费-批量删除")
    RestResponse<Void> batchRemoveExpressCostDetail(@RequestBody List<Long> ids);

    @PostMapping("/generateExpressCostData")
    @ApiOperation(value = "快递费-生成快递报表", notes = "快递费-生成快递报表")
    RestResponse<Void> generateExpressCostData(@RequestBody LogisticStatisticReqDto reqDto);

    @PostMapping("/editCost")
    @ApiOperation(value = "编辑费用", notes = "编辑费用")
    RestResponse<Void> editCost(@RequestBody ExpressCostDetailReqDto reqDto);
}
