package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ShipmentStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.ShipmentStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 近7天已发货统计服务接口
*
* @author 天泽
* @since 2022-12-14
*/
@Api(tags = {"近7天已发货统计服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-IShipmentStatisticsApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/shipment/statistics",
    url = "${tcbj.center.report.api:}"
)
public interface IShipmentStatisticsApi {

/**
* 新增近7天已发货统计
*
* @param addReqDto 近7天已发货统计请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增近7天已发货统计", notes = "新增近7天已发货统计")
RestResponse<Long> addShipmentStatistics(@RequestBody ShipmentStatisticsReqDto addReqDto);

    /**
    * 修改近7天已发货统计
    *
    * @param modifyReqDto 近7天已发货统计请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改近7天已发货统计", notes = "修改近7天已发货统计")
    RestResponse<Void> modifyShipmentStatistics(@RequestBody ShipmentStatisticsReqDto modifyReqDto);

    /**
    * 删除近7天已发货统计
    *
    * @param ids        近7天已发货统计删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除近7天已发货统计", notes = "删除近7天已发货统计")
    RestResponse<Void> removeShipmentStatistics(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
