package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShippingOrderTemplateDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 销售调拨报表服务
 *
 * @author jiejun
 */
@Api(tags = {"-销售调拨报表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/saleTransferReport", url = "${tcbj.center.report.api:}")
public interface ISaleTransferReportApi {

    @PostMapping("/queryByPage")
    @ApiOperation(value = "销售调拨报表分页查询", notes = "销售调拨报表分页查询")
    RestResponse<PageInfo<SaleTransferReportRespDto>> queryByPage(@RequestBody SaleTransferReportReqDto reqDto);

    @PostMapping("/queryPrintShippingOrderData")
    @ApiOperation(value = "获取打印托运单信息", notes = "获取打印托运单信息")
    RestResponse<List<ShippingOrderTemplateDto>> queryPrintShippingOrderData(@RequestBody List<String> saleOrderNos);
}
