package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 销售/销售退结果Dto
 */
@Data
public class SaleOrderResultOfFinanceRespDto {

    @ApiModelProperty(name = "documentNo",value = "结果单号")
    private String documentNo;

    @ApiModelProperty(name = "businessType",value = "业务类型，区分内部交易及信控前后置")
    private String businessType;

    @ApiModelProperty(name = "orderBusinessType",value = "单据业务类型")
    private String orderBusinessType;

    @ApiModelProperty(name = "orderType",value = "out-出库结果单，in-入库结果单")
    private String orderType;

    @ApiModelProperty(name = "createTime",value = "业务发生日期")
    private Date createTime;

    @ApiModelProperty(name = "organizationCode",value = "库存组织编号")
    private String organizationCode;

    @ApiModelProperty(name = "customerCode",value = "客户编号")
    private String customerCode;

    @ApiModelProperty(name = "relevanceNo",value = "来源销售订单，PCP销售单")
    private String relevanceNo;

    @ApiModelProperty(name = "platformOrderNo",value = "平台单号，（若是信控前后置单，则是营销云销售单；若是其他类型，则是EAS的销售单）")
    private String platformOrderNo;

    @ApiModelProperty(name = "remark",value = "备注")
    private String remark;

    @ApiModelProperty(name = "easSaleOrderNo",value = "eas销售单号")
    private String easSaleOrderNo;

    @ApiModelProperty(name = "dealerId",value = "进销商ID")
    private String dealerId;

    @ApiModelProperty(name = "saleType",value = "销售类型SALE：销售单，SALE_RED：销售红单")
    private String saleType;

    @ApiModelProperty(name = "sourceOrderNo",value = "源头单号，内部交易单号")
    private String sourceOrderNo;

    @ApiModelProperty(name = "sourceParentOrderNo",value = "源头父单号，内部交易父级单号")
    private String sourceParentOrderNo;

    @ApiModelProperty(name = "itemTotalAmount",value = "商品总金额")
    private String itemTotalAmount;

    @ApiModelProperty(name = "saleOrganizationCode",value = "销售组织编号")
    private String saleOrganizationCode;

    @ApiModelProperty(name = "saleChannel",value = "经销渠道（电商渠道）")
    private String saleChannel;

    @ApiModelProperty(name = "marketChannel",value = "销售渠道")
    private String marketChannel;

    @ApiModelProperty(name = "extension",value = "扩展信息")
    private String extension;

    @ApiModelProperty(name = "province",value = "省")
    private String province;

    @ApiModelProperty(name = "city",value = "市")
    private String city;

    @ApiModelProperty(name = "district",value = "区")
    private String district;

    @ApiModelProperty(name = "linkman",value = "联系人")
    private String linkman;

    @ApiModelProperty(name = "phone",value = "联系人电话")
    private String phone;

    @ApiModelProperty(name = "phone",value = "办事处")
    private String office;

    @ApiModelProperty(name = "address",value = "地址")
    private String address;

    @ApiModelProperty(name = "description",value = "摘要")
    private String description;

    @ApiModelProperty(name = "settlementOrgCode",value = "结算组织")
    private String settlementOrgCode;

    @ApiModelProperty(name = "salesOrgCode",value = "销售组织")
    private String salesOrgCode;

    @ApiModelProperty(name = "maiyouEasNo",value = "麦优EAS单号（佰健直销单据才有值）")
    private String maiyouEasNo;

    @ApiModelProperty(name = "maiyouCspNo",value = "麦优CSP单号（佰健直销单据才有值）")
    private String maiyouCspNo;

    private List<SaleOrderResultOfFinanceDetailRespDto> details = new ArrayList<>();
}
