package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "LogisticsInfoRespDto", description = "物流流水信息")
public class LogisticsInfoRespDto {
    @ApiModelProperty(name="consignmentNo", value = "物流单号")
    private String consignmentNo;
    @ApiModelProperty(name="deliveryWay", value = "发货方式")
    private String deliveryWay;
    @ApiModelProperty(name="carrierName", value = "物流公司")
    private String carrierName;
    @ApiModelProperty(name="detailList", value = "物流明细列表")
    private List<LogisticsInfoDetail> detailList;

    @Data
    @ApiModel(value = "LogisticsInfoDetail", description = "物流明细")
    public static class LogisticsInfoDetail{

        @ApiModelProperty(name="status", value = "物流状态： 0:提交，1：捡货，2：发货，3：在途，4.签收")
        private String status;
        @ApiModelProperty(name="operTime", value = "操作时间")
        private Date operTime;
        @ApiModelProperty(name="operInfo", value = "操作信息")
        private String operInfo;
    }

}
