package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.ReportTabCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.OutPlannedOrderVO;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 *
 */
@Api(tags = {"报表中心：调拨单统计"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/transferOrderReport",
        url = "${tcbj.center.report.api:}"
)
public interface ITransferOrderReportQueryApi {

    /**
     * 内部交易明细报表分页查询
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/internalDealReportPage")
    @ApiOperation(value = "内部交易明细报表分页查询", notes = "内部交易明细报表分页查询")
    RestResponse<PageInfo<TransferOrderReportRespDto>> internalDealReportPage(@RequestBody TransferOrderReportReqDto reqDto);

    /**
     * 内部交易明细已出库报表分页查询
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/internalDealOutReportPage")
    @ApiOperation(value = "内部交易明细已出库报表分页查询", notes = "内部交易明细已出库报表分页查询")
    RestResponse<PageInfo<TransferOrderReportRespDto>> internalDealOutReportPage(@RequestBody TransferOrderReportReqDto reqDto);

    /**
     * 内部交易明细报表tab数量统计
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/internalDealReportCount")
    @ApiOperation(value = "内部交易明细报表tab数量统计", notes = "内部交易明细报表tab数量统计")
    RestResponse<ReportTabCountRespDto> internalDealReportCount(@RequestBody TransferOrderReportReqDto reqDto);

    /**
     * 调拨单明细报表分页
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/transferOrderDetailReportPage")
    @ApiOperation(value = "调拨单明细报表分页", notes = "调拨单明细报表分页")
    RestResponse<PageInfo<TransferOrderReportRespDto>> transferOrderDetailReportPage(@RequestBody TransferOrderReportReqDto reqDto);

    /**
     * 调拨单明细已出库报表分页
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/transferOrderDetailOutReportPage")
    @ApiOperation(value = "调拨单明细已出库报表分页", notes = "调拨单明细已出库报表分页")
    RestResponse<PageInfo<TransferOrderReportRespDto>> transferOrderDetailOutReportPage(@RequestBody TransferOrderReportReqDto reqDto);

    /**
     * 调拨单明细报表tab数量统计
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/transferOrderDetailReportCount")
    @ApiOperation(value = "调拨单明细报表tab数量统计", notes = "调拨单明细报表tab数量统计")
    RestResponse<ReportTabCountRespDto> transferOrderDetailReportCount(@RequestBody TransferOrderReportReqDto reqDto);

    @PostMapping("/purchaseReturnDetailReportPage")
    @ApiOperation(value = "采购退货单明细报表分页", notes = "采购退货单明细报表分页")
    RestResponse<PageInfo<OutPlannedOrderVO>> purchaseReturnDetailReportPage(@RequestBody GetPurchaseReturnOrderListPageParams req);;
}
