package com.dtyunxi.tcbj.api.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DamageRateReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.DamageRateCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.DamageRateDetailReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.DamageRateReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"破损率报表统计"})
@FeignClient(
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/damageRateReport",
        url = "${com.dtyunxi.tcbj.api:}"
)
public interface IDamageRateReportQueryApi {

    @PostMapping("queryDamageRateReport")
    @ApiOperation(value = "承运商破损率统计", notes = "根据filter查询条件查询承运商破损率数据，filter=DamageRateReportReqDto")
    RestResponse<PageInfo<DamageRateReportRespDto>> queryDamageRateReport(@RequestBody DamageRateReportReqDto dto);

    @PostMapping("queryDamageRateDetailReport")
    @ApiOperation(value = "承运商破损率明细统计", notes = "根据filter查询条件查询承运商破损率数据，filter=DamageRateReportReqDto")
    RestResponse<PageInfo<DamageRateDetailReportRespDto>> queryDamageRateDetailReport(@RequestBody DamageRateReportReqDto dto);


    @PostMapping({"/queryCount"})
    @ApiOperation(value = "承运商破损率统计数据", notes = "根据filter查询条件查询承运商破损率统计数据，filter=DamageRateReportReqDto")
    RestResponse<DamageRateCountRespDto> queryCount(@RequestBody DamageRateReportReqDto filter);
}
