package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class SaleTransferReportReqDto extends BaseDto {

    @ApiModelProperty(name = "orderNo", value = "单号")
    private String orderNo;

    @ApiModelProperty(name = "orderNos", value = "单号集合")
    private List<String> orderNos;

    @ApiModelProperty(name = "orderType", value = "销售单据类型")
    private String orderType;

    @ApiModelProperty(name = "disposeStatus", value = "处理状态")
    private String disposeStatus;

    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    @ApiModelProperty(name = "secondOrderStatus", value = "单据子状态")
    private String secondOrderStatus;

    @ApiModelProperty(name = "transferType", value = "调拨类型")
    private String transferType;

    @ApiModelProperty(name = "transferTypeList", value = "调拨类型")
    private List<String> transferTypeList;

    @ApiModelProperty(name = "excludeTransferTypeList", value = "排除的调拨类型")
    private List<String> excludeTransferTypeList;

    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "provinceCode", value = "省编号")
    private String provinceCode;

    @ApiModelProperty(name = "cityCode", value = "市编号")
    private String cityCode;

    @ApiModelProperty(name = "countyCode", value = "区编号")
    private String countyCode;

    @ApiModelProperty(name = "logicalWarehouseCode", value = "指定发货仓")
    private String logicalWarehouseCode;

    @ApiModelProperty(name = "tagCodes", value = "手工标签")
    private List<String> tagCodes;

    @ApiModelProperty(name = "createTimeStart", value = "创建时间开始")
    private Date createTimeStart;

    @ApiModelProperty(name = "createTimeEnd", value = "创建时间结束")
    private Date createTimeEnd;

    @ApiModelProperty(name = "allotType", value = "调拨方式")
    private String allotType;

    @ApiModelProperty(name = "allotTypeList", value = "调拨方式")
    private List<String> allotTypeList;

    @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓编码")
    private String allotOutWarehouseCode;

    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
    private String allotInWarehouseCode;

    @ApiModelProperty(name = "allotOutWarehouseCodeList", value = "调出仓编码")
    private List<String> allotOutWarehouseCodeList;

    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
    private List<String> allotInWarehouseCodeList;
    @ApiModelProperty(name = "maiyouAllotTypeFlag", value = "麦优调拨类型 1 是;0 否")
    private String maiyouAllotTypeFlag = "0";
    @ApiModelProperty(name = "organizationIdList", value = "组织id集合")
    private List<Long> organizationIdList;

}
