package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportPollNumDto;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.yunxi.dg.base.center.report.dto.entity.MasterOrderDifferenceDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.MasterOrderDifferenceDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.text.ParseException;
import java.util.List;

/**
* 快递费用报表详情服务接口
*
* @author 天泽
* @since 2022-11-17
*/
@Api(tags = {"快递费用报表详情服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IExpressCostDetailQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/express/cost/detail",
    url = "${tcbj.center.report.api:}"
)
public interface IExpressCostDetailQueryApi {

    /**
    * 根据id查询快递费用报表详情
    *
    * @param id 快递费用报表详情id
    * @return   快递费用报表详情数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询快递费用报表详情", notes = "根据id查询快递费用报表详情")
    RestResponse<ExpressCostDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 快递费用报表详情分页数据
    *
    * @param queryDto   快递费用报表详情查询条件
    * @return 快递费用报表详情分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "快递费用报表详情分页数据", notes = "快递费用报表详情查询条件")
    RestResponse<PageInfo<ExpressCostDetailRespDto>> queryByPage(@RequestBody ExpressCostReportQueryDto queryDto);


    @PostMapping("/queryExpressCount")
    @ApiOperation(value = "快递费用报表统计数据", notes = "快递费用报表统计数据")
    RestResponse<ReInsuranceBillCountDto> queryExpressCount(@RequestBody(required = false) ExpressCostReportQueryDto queryDto);



    /**
     * 快递费-修改票数查询
     *
     * @param queryDto 更新账单数据
     * @return 处理结果
     */
    @PostMapping("/modifyPollQuery")
    @ApiOperation(value = "快递费-修改票数查询", notes = "快递费-修改票数查询")
    RestResponse<ExpressCostReportPollNumDto> modifyPollQuery(@RequestBody ExpressCostReportPollNumDto queryDto);
    /**
     * 快递费报表查询
     *
     * @param orderNos 快递费报表查询
     * @return 处理结果
     */
    @PostMapping("/queryListByOrders")
    @ApiOperation(value = "快递费-快递费报表查询", notes = "快递费-快递费报表查询")
    RestResponse<List<ExpressCostDetailRespDto>> queryListByOrders(@RequestBody List<String> orderNos);

    /**
     * 快递费-快递费报表查询(快递单号)
     *
     * @param orderNos 快递费-快递费报表查询(快递单号)
     * @return 处理结果
     */
    @PostMapping("/queryListByExpressOrders")
    @ApiOperation(value = "快递费-快递费报表查询(快递单号)", notes = "快递费-快递费报表查询(快递单号)")
    RestResponse<List<ExpressCostDetailRespDto>> queryListByExpressOrders(@RequestBody List<String> orderNos);

    @PostMapping("/queryList")
    @ApiOperation(value = "快递费用报表列表查询", notes = "快递费用报表列表查询")
    RestResponse<List<ExpressCostDetailRespDto>> queryList(@RequestBody ExpressCostDetailReqDto reqDto);

    @PostMapping("/queryPageMasterOrderDifference")
    @ApiOperation(value = "分页查询总单差异信息", notes = "分页查询总单差异信息")
    RestResponse<PageInfo<MasterOrderDifferenceDto>> queryPageMasterOrderDifference(@RequestBody ExpressCostReportQueryDto reqDto);

    @PostMapping("/queryPageMasterOrderDifferenceDetail")
    @ApiOperation(value = "分页查询总单差异明细信息", notes = "分页查询总单差异明细信息")
    RestResponse<PageInfo<MasterOrderDifferenceDetailDto>> queryPageMasterOrderDifferenceDetail(@RequestBody MasterOrderDifferenceDetailDto reqDto);


    /**
     * 快递费用报表更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "快递费用报表更新归档标识", notes = "快递费用报表更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

}
