/**
 * @(#)LockLogQueryDto.java 1.0 2022/05/30 15:49
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* @Description LockLogQueryDto
*
* @author wenyi
* @Date: 2022/05/30 15:49
* @since 1.0.0
*/
@ApiModel(value = "lockLogQueryDto", description = "查询Dto")
@Data
public class LockLogQueryDto implements Serializable {

    /** 锁库单号 */
    @ApiModelProperty(name="documentNo",value = "锁库单号")
    private String documentNo;
    /** 类型：lock 锁库，unlock 解锁 */
    @ApiModelProperty(name="type",value = "类型：lock 锁库，unlock 解锁")
    private String type;
    /** 逻辑仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "逻辑仓库编码")
    private String warehouseCode;
    /** 逻辑仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "逻辑仓库名称")
    private String warehouseName;
    /** 商品长编码 */
    @ApiModelProperty(name="longCode",value = "商品长编码")
    private String longCode;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 当前锁库/解锁数量 */
    @ApiModelProperty(name="currentQuantity",value = "当前锁库/解锁数量")
    private BigDecimal currentQuantity;
    /** 锁库原因 */
    @ApiModelProperty(name="remark",value = "锁库原因")
    private String remark;
    /** 过期日期 */
    @ApiModelProperty(name="expireTime",value = "过期日期")
    private Date expireTime;
    /** 生产日期 */
    @ApiModelProperty(name="produceTime",value = "生产日期")
    private Date produceTime;
    /** 组织ID */
    @ApiModelProperty(name="organizationId",value = "组织ID")
    private Long organizationId;
    /** 组织code */
    @ApiModelProperty(name="organizationCode",value = "组织code")
    private String organizationCode;
    /** 所属组织名称 */
    @ApiModelProperty(name="organizationName",value = "所属组织名称")
    private String organizationName;
    /** 起始创建时间 */
    @ApiModelProperty(name = "beginCreateTime", value = "起始创建时间 格式: yyyy-MM-dd HH:mm:ss")
    private String beginCreateTime;
    /** 结束创建时间 */
    @ApiModelProperty(name = "endCreateTime", value = "结束创建时间 格式: yyyy-MM-dd HH:mm:ss")
    private String endCreateTime;
    /** 日志状态：normal正常，abnormal异常 */
    @ApiModelProperty(name = "logStatus", value = "日志状态：normal正常，abnormal异常")
    private String logStatus;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    private List<String> warehouseCodes;

    private List<String> cargoCodes;

    private List<String> batches;
}