package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CombinedPackageActivityReqDto;
import com.dtyunxi.tcbj.api.dto.response.CombinedPackageActivityRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 组合套装活动接口服务
 *
 * @author haoyang
 * @date 2021/11/22 20:13
 * @since 0.1.0
 */
@Api(tags = {"报表中心:组合套装活动接口服务"})
@FeignClient(name = "${tcbj.center.report.api.name:tcbj-center-report}",
        url = "${tcbj.center.report.api:}",
        path = "/v1/combined/package/activity"
)
public interface ICombinedPackageActivityApi {
    /**
     * 分页查询满足条件的组合套餐活动信息
     *
     * @return 分页活动列表信息
     */
    @PostMapping("/queryCombinedPackageActivity")
    @ApiOperation(value = "分页查询满足条件的组合套餐活动信息", notes = "分页查询满足条件的组合套餐活动信息")
    RestResponse<PageInfo<CombinedPackageActivityRespDto>> queryCombinedPackageActivity(@RequestBody CombinedPackageActivityReqDto combinedPackageActivityReqDto);

}
