package com.dtyunxi.tcbj.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 保费计算所需商品明细VO对象
* @author lshaowu
* @time 2022/7/25 19:58
* @description
*/
@ApiModel(value = "InsuranceItemVo", description = "保费计算所需商品明细VO对象")
@Data
public class InsuranceItemVo {
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;

    @ApiModelProperty(name = "recommendPrice", value = "建议零售价")
    private BigDecimal recommendPrice;

    @ApiModelProperty(name = "claimPrice", value = "投保零售价")
    private BigDecimal claimPrice;

    //优先取投保价，其次取零售价
    //private BigDecimal price;

}
