package com.dtyunxi.tcbj.api.dto.response.es;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 销售退货单列表
 */
@Data
public class SaleRefundRespVo implements Serializable {
    private Long id;
    private String saleRefundNo;
    private String refundStatus;
    private String refundType;
    private String platformRefundNo;
    private String customerName;
    private String applyRefundWarehouseName;
    private String refundWarehouseName;
    private Date platformRefundCreateTime;
    private String province;
    private String provinceCode;
    private String city;
    private String cityCode;
    private String county;
    private String countyCode;
    private String receiveAddress;
    private String receiveName;
    private String receivePhone;
    private String refundTotalAmount;
    private Date actualRefundTime;
    private String saleOrgName;
    private Date createTime;
    private String createPerson;
    private Date updateTime;
    private String updatePerson;
    private Integer dr;


    /**
     *  组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
     *  组织code
     */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
     *  组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     *  平台退货申请时间
     */
    @ApiModelProperty(name = "platformRefundApplyTime", value = "平台退货申请时间")
    private Date platformRefundApplyTime;

    /**
     *  内部销售退货单号（暂时没用）
     */
    @ApiModelProperty(name = "refundNo", value = "内部销售退货单号（暂时没用）")
    private String refundNo;

    /**
     *  第三方客户租户id
     */
    @ApiModelProperty(name = "thirdPartyId", value = "第三方客户租户id")
    private String thirdPartyId;
    /**
     *  联系人名称
     */
    @ApiModelProperty(name = "contactPersonName", value = "联系人名称")
    private String contactPersonName;
    /**
     *  联系电话
     */
    @ApiModelProperty(name = "contactPhone", value = "联系电话")
    private String contactPhone;

    /**
     *  订单渠道id
     */
    @ApiModelProperty(name = "orderChannelId", value = "订单渠道id")
    private Long orderChannelId;
    /**
     *  订单渠道code
     */
    @ApiModelProperty(name = "orderChannelCode", value = "订单渠道code")
    private String orderChannelCode;
    /**
     *  订单渠道名称
     */
    @ApiModelProperty(name = "orderChannelName", value = "订单渠道名称")
    private String orderChannelName;
    /**
     *  客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    /**
     *  客户id
     */
    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;
    /**
     *  商品总数量
     */
    @ApiModelProperty(name = "goodsTotalNum", value = "商品总数量")
    private BigDecimal goodsTotalNum;
    /**
     *  商品sku总数量
     */
    @ApiModelProperty(name = "goodsSkuTotalNum", value = "商品sku总数量")
    private BigDecimal goodsSkuTotalNum;
    /**
     *  申请销售退货仓编码
     */
    @ApiModelProperty(name = "applyRefundWarehouseCode", value = "申请销售退货仓编码")
    private String applyRefundWarehouseCode;
    /**
     *  申请销售退货仓id
     */
    @ApiModelProperty(name = "applyRefundWarehouseId", value = "申请销售退货仓id")
    private Long applyRefundWarehouseId;

    /**
     *  所用流程
     */
    @ApiModelProperty(name = "flowDefId", value = "所用流程")
    private Long flowDefId;

    /**
     *  下单所属子公司eas组织id
     */
    @ApiModelProperty(name = "easOrgId", value = "下单所属子公司eas组织id")
    private String easOrgId;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 来源类型，0-csp推单，1-手工创建，默认0
     */
    @ApiModelProperty(name="sourceType",value = "来源类型，0-csp推单，1-手工创建，默认0")
    private Integer sourceType;

}
