package com.dtyunxi.tcbj.api.dto.constant.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Objects;

public enum  ActivityTypeEnum {

    AC_PT("1","拼团活动"),
    AC_YH("2", "优惠券活动"),
    AC_MS("3", "秒杀活动"),
    AC_CX("4", "促销活动"),
    AC_JF("5","积分抵扣活动"),
    AC_XS("6","限时特价活动"),

    ;


    private String status;

    private String value;

    ActivityTypeEnum(String status, String value) {
        this.status = status;
        this.value = value;
    }

    public static String getValueByCode(String type){
        if (StringUtils.isBlank(type)){
            return type;
        }
        return Objects.requireNonNull(Arrays.stream(ActivityTypeEnum.values()).filter(enums -> enums.getStatus().equals(type)).findFirst().orElse(null)).getValue();
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
