package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataDto;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataMonitorDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"销售单合单数据服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/saleOrderMergeDataApi",
        url = "${tcbj.center.report.api:}"
)
public interface ISaleOrderMergeDataApi {

    @PostMapping("/addBatch")
    @ApiOperation(value = "批量新增", notes = "批量新增")
    RestResponse<Void> addBatch(@RequestBody List<SaleOrderMergeDataDto> dtoList);

    @PostMapping("/buildSaleOrderMergeData")
    @ApiOperation(value = "构建销售单合单数据", notes = "构建销售单合单数据")
    RestResponse<Void> buildSaleOrderMergeData(@RequestBody SaleOrderMergeDataDto dto);

    @PostMapping("/updateSaleOrderMergeData")
    @ApiOperation(value = "更新销售单合单数据", notes = "更新销售单合单数据")
    RestResponse<Void> updateSaleOrderMergeData(@RequestBody SaleOrderMergeDataDto dto);

    @PostMapping("/queryPage")
    @ApiOperation(value = "分页查询销售单合单数据", notes = "分页查询销售单合单数据")
    RestResponse<PageInfo<SaleOrderMergeDataDto>> queryPage(@RequestBody SaleOrderMergeDataDto dto);

    @PostMapping("/queryMonitorPageInfo")
    @ApiOperation(value = "查询销售合并推送监控数据", notes = "查询销售合并推送监控数据")
    RestResponse<PageInfo<SaleOrderMergeDataMonitorDto>> queryMonitorPageInfo(@RequestBody SaleOrderMergeDataMonitorDto dto);
}
