package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author tangjiaye
 * @since 2.0.0
 */
@Data
@ApiModel(value = "质检转合格查询入参")
public class QualityInfoReqDto extends BasePageDto {

    @ApiModelProperty(name = "inventoryIds", value = "库存id集合")
    private List<Long> inventoryIds;

    @ApiModelProperty(name = "notInventoryIds", value = "库存id集合")
    private List<Long> notInventoryIds;

    @ApiModelProperty(name = "plannedOrderNo", value = "计划单号")
    private String plannedOrderNo;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "batchs", value = "批次")
    private List<String> batchs;

    @ApiModelProperty(name = "longCodes", value = "商品长编码")
    private List<String> longCodes;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "dischargedStatus", value = "放行状态：unPassed-否(待放行),passed-是(已放行)")
    private String dischargedStatus;

    @ApiModelProperty(name = "startTime", value = "查询开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "查询结束时间")
    private String endTime;

    @ApiModelProperty(name = "wmsStatus", value = "推送WMS状态")
    private String wmsStatus;
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "reportStatus", value = "报告状态")
    private String reportStatus;

    /**
     * 超7天未出报告,
     */
    @ApiModelProperty(name = "dischargedReport", value = "超7天未出报告,1-是,0-否")
    private String dischargedReport;

    /**
     * 超7天未放行,unPassed-是(未放行),passed-否(已放行)
     */
    @ApiModelProperty(name = "dischargedFlag", value = "超7天未放行,1-是(未放行),0-否(已放行),2-未出报告")
    private String  dischargedFlag;



}
