package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.AllocationLogisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticsInReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticsInReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.AllocationLogisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticsInReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogisticsStatisticsRespDto;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.websocket.server.PathParam;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

@Api(tags = {"物流在途报表"})
@FeignClient(
        name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",
        path = "/v1/report/",
        url = "${tcbj.center.report.api:}"
)
public interface LogisticsInReportApi {
    @ApiOperation(
        tags = { "reportCenter/finishedGoodsInventory/logisticsInReport" },
        value = "物流在途报表",
        nickname = "getLogisticsInReportListPage",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "finishedGoodsInventory/logisticsInReport",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<LogisticsInReportRespDto>> getLogisticsInReportListPage(
            @RequestBody(required = false) LogisticsInReportQueryDto logisticsInReportReqDto
    ) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException;

    @ApiOperation(
            tags = { "reportCenter/finishedGoodsInventory/logisticsInReport" },
            value = "物流在途报表",
            nickname = "getLogisticsInReportListPage"    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "finishedGoodsInventory/logisticsInReport/generate"
    )
    RestResponse<Void> generateLogisticsInReport(@RequestParam("startDate") String startDate,@RequestParam("endDate")String endDate);



    @ApiOperation(
            tags = { "reportCenter/finishedGoodsInventory/AllocationLogistics" },
            value = "调拨在途报表",
            nickname = "getAllocationLogisticsPage",
            notes = ""
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "finishedGoodsInventory/AllocationLogistics",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<PageInfo<AllocationLogisticsRespDto>> getAllocationLogisticsPage(
            @RequestBody(required = false) AllocationLogisticsQueryDto allocationLogisticsQueryDto
    );

    /**
     * 超时在途数据统计
     * @param type 1. 近7天，2.近30天
     * @return
     */
    @ApiOperation(value = "数据大屏-超时在途数据统计", notes = "数据大屏-超时在途数据统计")
    @GetMapping("/queryLogisticsStatistics/{type}")
    RestResponse<List<LogisticsStatisticsRespDto>> queryLogisticsStatistics(@PathVariable("type") Integer type);


    @ApiOperation(
            tags = { "reportCenter/finishedGoodsInventory/LogisticsInReportDetailsPage" },
            value = "物流在途报表明细",
            nickname = "LogisticsInReportDetailsPage",
            notes = ""
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
            method = RequestMethod.POST,
            value = "finishedGoodsInventory/LogisticsInReportDetailsPage",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<PageInfo<LogisticsInReportRespDto>> queryLogisticsInReportDetailsPage(@RequestBody(required = false) LogisticsInReportQueryDto logisticsInReportReqDto);
}
