package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.tomcat.jni.Local;

import java.time.LocalDateTime;

/**
 * @author fengzr
 * @data 2023-11-14 15:17
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "InTransitInNoticeDetailReqDto", description = "在途仓里指定sku的入库通知单明细数量请求对象")
public class InTransitInNoticeDetailReqDto extends BasePageDto {

    @ApiModelProperty(name = "inTransitWarehouseCode", value = "在途合格仓编码")
    private String inTransitWarehouseCode;

    @ApiModelProperty(name = "inTransitWarehouseName", value = "在途合格仓名称")
    private String inTransitWarehouseName;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "skuName", value = "sku名称")
    private String skuName;

    @ApiModelProperty(name = "planArriveTimeStart", value = "预计到达时间开始")
    private LocalDateTime planArriveTimeStart;

    @ApiModelProperty(name = "planArriveTimeEnd", value = "预计到达时间结束")
    private LocalDateTime planArriveTimeEnd;

    @ApiModelProperty(name = "quantity", value = "数量")
    private Integer quantity;

}
