package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * 运单配送信息Eo对象
 *
 * @author 无凡
 * @since 2023-04-11
 */
@ApiModel(value = "ConsignmentOrderDeliveryInfoRespDto", description = "运单配送信息Eo对象")
@Getter
@Setter
public class ConsignmentOrderDeliveryInfoRespDto extends BaseRespDto{
    /**
     *  运单号
     */
    @ApiModelProperty(name = "consignmentNo", value = "运单号")
    private String consignmentNo;
    /**
     *  wms运单号
     */
    @ApiModelProperty(name = "wmsConsignmentNo", value = "wms运单号")
    private String wmsConsignmentNo;
    /**
     *  出库结果单单号
     */
    @ApiModelProperty(name = "outResultNo", value = "出库结果单单号")
    private String outResultNo;
    /**
     *  出库通知单单号
     */
    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;
    /**
     *  业务单号
     */
    @ApiModelProperty(name = "businessNo", value = "业务单号")
    private String businessNo;
    /**
     *  外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
     *  合单号
     */
    @ApiModelProperty(name = "mergeOrderNo", value = "合单号")
    private String mergeOrderNo;
    /**
     *  承运商编码
     */
    @ApiModelProperty(name = "carrierCode", value = "承运商编码")
    private String carrierCode;
    /**
     *  承运商名称
     */
    @ApiModelProperty(name = "carrierName", value = "承运商名称")
    private String carrierName;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "carrierType", value = "承运方式")
    private String carrierType;
    /**
     *  承运单号
     */
    @ApiModelProperty(name = "carrierNo", value = "承运单号")
    private String carrierNo;
    /**
     *  车牌号
     */
    @ApiModelProperty(name = "carLicenseNo", value = "车牌号")
    private String carLicenseNo;
    /**
     *  司机名称
     */
    @ApiModelProperty(name = "driverName", value = "司机名称")
    private String driverName;
    /**
     *  司机电话
     */
    @ApiModelProperty(name = "driverPhone", value = "司机电话")
    private String driverPhone;
    /**
     *  发货时间
     */
    @ApiModelProperty(name = "deliveryTime", value = "发货时间")
    private Date deliveryTime;
    /**
     *  计划到达天数
     */
    @ApiModelProperty(name = "planArriveDays", value = "计划到达天数")
    private Integer planArriveDays;
    /**
     *  计划到达时间
     */
    @ApiModelProperty(name = "planArriveTime", value = "计划到达时间")
    private Date planArriveTime;
    /**
     *  实际到达时间
     */
    @ApiModelProperty(name = "actualArriveTime", value = "实际到达时间")
    private Date actualArriveTime;

    @ApiModelProperty(name = "secondaryConsignmentNo", value = "副托运单号")
    private String secondaryConsignmentNo;
}
