package com.dtyunxi.tcbj.api.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StringCheckResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.StringCheckResultRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 串码校验结果服务接口
*
* @author author
* @since 2022-09-22
*/
@Api(tags = {"串码校验结果服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/stringCheck/log", url = "${tcbj.center.report.api:}")
public interface IStringCheckResultQueryApi {

    /**
    * 根据id查询串码校验结果
    *
    * @param id 串码校验结果id
    * @return   串码校验结果数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询串码校验结果", notes = "根据id查询串码校验结果")
    RestResponse<StringCheckResultRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 串码校验结果分页数据
    *
    * @param reqDto   串码校验结果查询条件
    * @return 串码校验结果分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "串码校验结果分页数据", notes = "根据filter查询条件查询串码校验结果数据，filter=StringCheckResultReqDto")
    RestResponse<PageInfo<StringCheckResultRespDto>> queryByPage(@RequestBody StringCheckResultReqDto reqDto);

}
