package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDeliverQuantityReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostDeliverQuantityRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 快递费用月统计发货量服务接口
*
* @author author
* @since 2025-02-18
*/
@Api(tags = {"快递费用月统计发货量服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IExpressCostDeliverQuantityApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/expressCostDeliverQuantity",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressCostDeliverQuantityApi {

    /**
    * 新增快递费用月统计发货量
    *
    * @param addReqDto 快递费用月统计发货量请求对象
    * @return 处理结果
    */
    @PostMapping("/addExpressCostDeliverQuantity")
    @ApiOperation(value = "新增快递费用月统计发货量", notes = "新增快递费用月统计发货量")
    RestResponse<Long> addExpressCostDeliverQuantity(@RequestBody ExpressCostDeliverQuantityReqDto addReqDto);

    /**
    * 修改快递费用月统计发货量
    *
    * @param modifyReqDto 快递费用月统计发货量请求对象
    * @return 处理结果
    */
    @PostMapping("/modifyExpressCostDeliverQuantity")
    @ApiOperation(value = "修改快递费用月统计发货量", notes = "修改快递费用月统计发货量")
    RestResponse<Void> modifyExpressCostDeliverQuantity(@RequestBody ExpressCostDeliverQuantityReqDto modifyReqDto);

    /**
    * 删除快递费用月统计发货量
    *
    * @param ids        快递费用月统计发货量删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除快递费用月统计发货量", notes = "删除快递费用月统计发货量")
    RestResponse<Void> removeExpressCostDeliverQuantity(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
