package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;
import io.swagger.models.auth.In;
import lombok.Data;

/**
* 营养家和其他出库下单统计Eo对象
*
* @author 紫霄
* @since 2023-08-02
*/
@ApiModel(value = "ReSalesOrderOtherRespDto", description = "营养家和其他出库下单统计Eo对象")
@Data
public class ReSalesOrderOtherRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  下单日期
    */
    @ApiModelProperty(name = "saleCreateDate", value = "下单日期")
    private String saleCreateDate;
    /**
    *  类型,1:营养家，2：其他出库
    */
    @ApiModelProperty(name = "type", value = "类型,1:营养家，2：其他出库")
    private Integer type;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *   组织id
    */
    @ApiModelProperty(name = "organizationId", value = " 组织id")
    private Long organizationId;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  票数
    */
    @ApiModelProperty(name = "number", value = "票数")
    private Long number;
    /**
    *  体积
    */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

}
